/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.FileAttributes;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.Rethrow;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NamespaceFilesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NamespaceFilesService.class);
    @Inject
    private StorageInterface storageInterface;

    public List<URI> inject(RunContext runContext, String tenantId, String namespace, Path basePath, NamespaceFiles namespaceFiles) throws Exception {
        if (!namespaceFiles.getEnabled().booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<URI> list = new ArrayList<URI>();
        list.addAll(this.recursiveList(tenantId, namespace, null));
        list = list.stream().filter(Rethrow.throwPredicate(f -> {
            boolean b;
            String file = f.getPath();
            if (namespaceFiles.getExclude() != null && (b = NamespaceFilesService.match(runContext.render(namespaceFiles.getExclude()), file))) {
                return false;
            }
            return namespaceFiles.getInclude() == null || (b = NamespaceFilesService.match(namespaceFiles.getInclude(), file));
        })).collect(Collectors.toList());
        this.copy(tenantId, namespace, basePath, list);
        return list;
    }

    private URI uri(String namespace, @Nullable URI path) {
        return URI.create(this.storageInterface.namespaceFilePrefix(namespace) + Optional.ofNullable(path).map(URI::getPath).orElse(""));
    }

    private List<URI> recursiveList(String tenantId, String namespace, @Nullable URI path) throws IOException {
        URI uri = this.uri(namespace, path);
        ArrayList<URI> result = new ArrayList<URI>();
        List<FileAttributes> list = this.storageInterface.list(tenantId, uri);
        for (FileAttributes file : list) {
            URI current = URI.create((path != null ? path.getPath() : "") + "/" + file.getFileName());
            if (file.getType() == FileAttributes.FileType.Directory) {
                result.addAll(this.recursiveList(tenantId, namespace, current));
                continue;
            }
            result.add(current);
        }
        return result;
    }

    private static boolean match(List<String> patterns, String file) {
        return patterns.stream().anyMatch(s -> FileSystems.getDefault().getPathMatcher("glob:" + s).matches(Paths.get(file, new String[0])));
    }

    private void copy(String tenantId, String namespace, Path basePath, List<URI> files) throws IOException {
        files.forEach(Rethrow.throwConsumer(f -> {
            Path destination = Paths.get(basePath.toString(), f.getPath());
            if (!destination.getParent().toFile().exists()) {
                destination.getParent().toFile().mkdirs();
            }
            try (InputStream inputStream = this.storageInterface.get(tenantId, this.uri(namespace, (URI)f));){
                Files.copy(inputStream, destination, new CopyOption[0]);
            }
        }));
    }
}

