/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import com.cronutils.utils.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.queues.QueueInterface;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunContextLogger {
    private static final int MAX_MESSAGE_LENGTH = 10240;
    private final String loggerName;
    private ch.qos.logback.classic.Logger logger;
    private QueueInterface<LogEntry> logQueue;
    private LogEntry logEntry;
    private Level loglevel;

    @VisibleForTesting
    public RunContextLogger() {
        this.loggerName = "unit-test";
    }

    public RunContextLogger(QueueInterface<LogEntry> logQueue, LogEntry logEntry, org.slf4j.event.Level loglevel) {
        this.loggerName = logEntry.getExecutionId() != null ? "flow." + logEntry.getFlowId() + "." + logEntry.getExecutionId() + (String)(logEntry.getTaskRunId() != null ? "." + logEntry.getTaskRunId() : "") : "flow." + logEntry.getFlowId() + "." + logEntry.getTriggerId();
        this.logQueue = logQueue;
        this.logEntry = logEntry;
        this.loglevel = loglevel == null ? Level.TRACE : Level.toLevel((String)loglevel.toString());
    }

    private static List<LogEntry> logEntry(ILoggingEvent event, String message, org.slf4j.event.Level level, LogEntry logEntry) {
        if (message == null) {
            return new ArrayList<LogEntry>();
        }
        Iterable<String> split = message.length() > 10240 ? Splitter.fixedLength((int)10240).split((CharSequence)message) : Collections.singletonList(message);
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        long i = 0L;
        for (String s : split) {
            result.add(LogEntry.builder().namespace(logEntry.getNamespace()).tenantId(logEntry.getTenantId()).flowId(logEntry.getFlowId()).taskId(logEntry.getTaskId()).executionId(logEntry.getExecutionId()).taskRunId(logEntry.getTaskRunId()).attemptNumber(logEntry.getAttemptNumber()).triggerId(logEntry.getTriggerId()).level(level != null ? level : org.slf4j.event.Level.valueOf((String)event.getLevel().toString())).message(s).timestamp(Instant.ofEpochMilli(event.getTimeStamp()).plusMillis(i)).thread(event.getThreadName()).build());
            ++i;
        }
        return result;
    }

    public static List<LogEntry> logEntries(ILoggingEvent event, LogEntry logEntry) {
        Throwable throwable = RunContextLogger.throwable(event);
        if (throwable == null) {
            return RunContextLogger.logEntry(event, event.getFormattedMessage(), null, logEntry);
        }
        ArrayList<LogEntry> result = new ArrayList<LogEntry>(RunContextLogger.logEntry(event, event.getFormattedMessage(), null, logEntry));
        if (Throwables.getCausalChain((Throwable)throwable).size() > 1) {
            result.addAll(RunContextLogger.logEntry(event, Throwables.getCausalChain((Throwable)throwable).stream().skip(1L).map(Throwable::getMessage).collect(Collectors.joining("\n")), null, logEntry));
        }
        result.addAll(RunContextLogger.logEntry(event, Throwables.getStackTraceAsString((Throwable)throwable), org.slf4j.event.Level.TRACE, logEntry));
        return result;
    }

    private static Throwable throwable(ILoggingEvent event) {
        Throwable result = null;
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (null != throwableProxy && throwableProxy instanceof ThrowableProxy) {
            result = ((ThrowableProxy)throwableProxy).getThrowable();
        }
        return result;
    }

    public Logger logger() {
        if (this.logger == null) {
            LoggerContext loggerContext = new LoggerContext();
            this.logger = loggerContext.getLogger(this.loggerName);
            if (this.logQueue != null && this.logEntry != null) {
                ContextAppender contextAppender = new ContextAppender(this.logQueue, this.logEntry);
                contextAppender.setContext((Context)loggerContext);
                contextAppender.start();
                this.logger.addAppender((Appender)contextAppender);
            }
            ForwardAppender forwardAppender = new ForwardAppender();
            forwardAppender.setContext((Context)loggerContext);
            forwardAppender.start();
            this.logger.addAppender((Appender)forwardAppender);
            this.logger.setLevel(this.loglevel);
            this.logger.setAdditive(true);
        }
        return this.logger;
    }

    public static class ContextAppender
    extends AppenderBase<ILoggingEvent> {
        private final QueueInterface<LogEntry> logQueue;
        private final LogEntry logEntry;

        public ContextAppender(QueueInterface<LogEntry> logQueue, LogEntry logEntry) {
            this.logQueue = logQueue;
            this.logEntry = logEntry;
        }

        protected void append(ILoggingEvent e) {
            RunContextLogger.logEntries(e, this.logEntry).forEach(this.logQueue::emitAsync);
        }
    }

    public static class ForwardAppender
    extends AppenderBase<ILoggingEvent> {
        private static final Logger LOGGER = LoggerFactory.getLogger((String)"flow");

        public void start() {
            super.start();
        }

        public void stop() {
            super.stop();
        }

        protected void append(ILoggingEvent e) {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LOGGER;
            if (logger.isEnabledFor(e.getLevel())) {
                ((ch.qos.logback.classic.Logger)LOGGER).callAppenders(e);
            }
        }
    }
}

