/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.ExecutorInterface;
import io.kestra.core.runners.IndexerInterface;
import io.kestra.core.runners.RunnerInterface;
import io.kestra.core.runners.Worker;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.schedulers.AbstractScheduler;
import io.kestra.core.utils.ExecutorsUtils;
import io.kestra.core.utils.Rethrow;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandAloneRunner
implements RunnerInterface,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandAloneRunner.class);
    private ExecutorService poolExecutor;
    protected int workerThread = Math.max(3, Runtime.getRuntime().availableProcessors());
    protected boolean schedulerEnabled = true;
    protected boolean workerEnabled = true;
    @Inject
    private ExecutorsUtils executorsUtils;
    @Inject
    @Named(value="executionQueue")
    protected QueueInterface<Execution> executionQueue;
    @Inject
    @Named(value="workerJobQueue")
    protected QueueInterface<WorkerJob> workerTaskQueue;
    @Inject
    @Named(value="workerTaskResultQueue")
    protected QueueInterface<WorkerTaskResult> workerTaskResultQueue;
    @Inject
    private ApplicationContext applicationContext;
    private final List<AutoCloseable> servers = new ArrayList<AutoCloseable>();
    private boolean running = false;

    @Override
    public void run() {
        this.running = true;
        this.poolExecutor = this.executorsUtils.cachedThreadPool("standalone-runner");
        this.poolExecutor.execute((Runnable)this.applicationContext.getBean(ExecutorInterface.class));
        if (this.workerEnabled) {
            Worker worker = new Worker(this.applicationContext, this.workerThread, null);
            this.applicationContext.registerSingleton((Object)worker);
            this.poolExecutor.execute(worker);
            this.servers.add(worker);
        }
        if (this.schedulerEnabled) {
            AbstractScheduler scheduler = (AbstractScheduler)this.applicationContext.getBean(AbstractScheduler.class);
            this.poolExecutor.execute(scheduler);
            this.servers.add(scheduler);
        }
        if (this.applicationContext.containsBean(IndexerInterface.class)) {
            IndexerInterface indexer = (IndexerInterface)this.applicationContext.getBean(IndexerInterface.class);
            this.poolExecutor.execute(indexer);
            this.servers.add(indexer);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void close() throws Exception {
        this.servers.forEach(Rethrow.throwConsumer(AutoCloseable::close));
        this.poolExecutor.shutdown();
        this.executionQueue.close();
        this.workerTaskQueue.close();
        this.workerTaskResultQueue.close();
    }

    @Generated
    public void setPoolExecutor(ExecutorService poolExecutor) {
        this.poolExecutor = poolExecutor;
    }

    @Generated
    public void setWorkerThread(int workerThread) {
        this.workerThread = workerThread;
    }

    @Generated
    public void setSchedulerEnabled(boolean schedulerEnabled) {
        this.schedulerEnabled = schedulerEnabled;
    }

    @Generated
    public void setWorkerEnabled(boolean workerEnabled) {
        this.workerEnabled = workerEnabled;
    }
}

