/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.runners.WorkerTask;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public final class WorkerTaskResult {
    @NotNull
    private final TaskRun taskRun;
    private final List<TaskRun> dynamicTaskRuns;

    public WorkerTaskResult(TaskRun taskRun) {
        this.taskRun = taskRun;
        this.dynamicTaskRuns = new ArrayList<TaskRun>();
    }

    public WorkerTaskResult(WorkerTask workerTask) {
        this.taskRun = workerTask.getTaskRun();
        this.dynamicTaskRuns = new ArrayList<TaskRun>();
    }

    public WorkerTaskResult(WorkerTask workerTask, List<WorkerTaskResult> dynamicWorkerResults) {
        this.taskRun = workerTask.getTaskRun();
        this.dynamicTaskRuns = dynamicWorkerResults.stream().map(WorkerTaskResult::getTaskRun).collect(Collectors.toList());
    }

    @Generated
    public static WorkerTaskResultBuilder builder() {
        return new WorkerTaskResultBuilder();
    }

    @Generated
    public TaskRun getTaskRun() {
        return this.taskRun;
    }

    @Generated
    public List<TaskRun> getDynamicTaskRuns() {
        return this.dynamicTaskRuns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerTaskResult)) {
            return false;
        }
        WorkerTaskResult other = (WorkerTaskResult)o;
        TaskRun this$taskRun = this.getTaskRun();
        TaskRun other$taskRun = other.getTaskRun();
        if (this$taskRun == null ? other$taskRun != null : !((Object)this$taskRun).equals(other$taskRun)) {
            return false;
        }
        List<TaskRun> this$dynamicTaskRuns = this.getDynamicTaskRuns();
        List<TaskRun> other$dynamicTaskRuns = other.getDynamicTaskRuns();
        return !(this$dynamicTaskRuns == null ? other$dynamicTaskRuns != null : !((Object)this$dynamicTaskRuns).equals(other$dynamicTaskRuns));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TaskRun $taskRun = this.getTaskRun();
        result = result * 59 + ($taskRun == null ? 43 : ((Object)$taskRun).hashCode());
        List<TaskRun> $dynamicTaskRuns = this.getDynamicTaskRuns();
        result = result * 59 + ($dynamicTaskRuns == null ? 43 : ((Object)$dynamicTaskRuns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerTaskResult(taskRun=" + this.getTaskRun() + ", dynamicTaskRuns=" + this.getDynamicTaskRuns() + ")";
    }

    @ConstructorProperties(value={"taskRun", "dynamicTaskRuns"})
    @Generated
    public WorkerTaskResult(TaskRun taskRun, List<TaskRun> dynamicTaskRuns) {
        this.taskRun = taskRun;
        this.dynamicTaskRuns = dynamicTaskRuns;
    }

    @Generated
    public static class WorkerTaskResultBuilder {
        @Generated
        private TaskRun taskRun;
        @Generated
        private List<TaskRun> dynamicTaskRuns;

        @Generated
        WorkerTaskResultBuilder() {
        }

        @Generated
        public WorkerTaskResultBuilder taskRun(TaskRun taskRun) {
            this.taskRun = taskRun;
            return this;
        }

        @Generated
        public WorkerTaskResultBuilder dynamicTaskRuns(List<TaskRun> dynamicTaskRuns) {
            this.dynamicTaskRuns = dynamicTaskRuns;
            return this;
        }

        @Generated
        public WorkerTaskResult build() {
            return new WorkerTaskResult(this.taskRun, this.dynamicTaskRuns);
        }

        @Generated
        public String toString() {
            return "WorkerTaskResult.WorkerTaskResultBuilder(taskRun=" + this.taskRun + ", dynamicTaskRuns=" + this.dynamicTaskRuns + ")";
        }
    }
}

