/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.Slugify;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

@Singleton
public class ReadFileFunction
implements Function {
    private static final String ERROR_MESSAGE = "The 'read' function expects an argument 'path' that is a path to a namespace file or an internal storage URI.";
    private static final String KESTRA_SCHEME = "kestra:///";
    @Inject
    private StorageInterface storageInterface;

    public List<String> getArgumentNames() {
        return List.of("path");
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        if (!args.containsKey("path")) {
            throw new PebbleException(null, ERROR_MESSAGE, Integer.valueOf(lineNumber), self.getName());
        }
        String path = (String)args.get("path");
        try {
            return path.startsWith(KESTRA_SCHEME) ? this.readFromInternalStorageUri(context, path) : this.readFromNamespaceFile(context, path);
        }
        catch (IOException e) {
            throw new PebbleException((Throwable)e, e.getMessage(), Integer.valueOf(lineNumber), self.getName());
        }
    }

    private String readFromNamespaceFile(EvaluationContext context, String path) throws IOException {
        Map flow = (Map)context.getVariable("flow");
        URI namespaceFile = URI.create(this.storageInterface.namespaceFilePrefix((String)flow.get("namespace")) + "/" + path);
        try (InputStream inputStream = this.storageInterface.get((String)flow.get("tenantId"), namespaceFile);){
            String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private String readFromInternalStorageUri(EvaluationContext context, String path) throws IOException {
        Map flow = (Map)context.getVariable("flow");
        Map execution = (Map)context.getVariable("execution");
        if (!this.validateFileUri((String)flow.get("namespace"), (String)flow.get("id"), (String)execution.get("id"), path)) {
            if (context.getVariable("trigger") != null) {
                Map trigger = (Map)context.getVariable("trigger");
                if (!this.validateFileUri((String)trigger.get("namespace"), (String)trigger.get("flowId"), (String)trigger.get("executionId"), path)) {
                    throw new IllegalArgumentException("Unable to read the file '" + path + "' as it didn't belong to the current execution");
                }
            } else {
                throw new IllegalArgumentException("Unable to read the file '" + path + "' as it didn't belong to the current execution");
            }
        }
        URI internalStorageFile = URI.create(path);
        try (InputStream inputStream = this.storageInterface.get((String)flow.get("tenantId"), internalStorageFile);){
            String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private boolean validateFileUri(String namespace, String flowId, String executionId, String path) {
        if (namespace == null || flowId == null || executionId == null) {
            return false;
        }
        String authorizedBasePath = KESTRA_SCHEME + namespace.replace(".", "/") + "/" + Slugify.of(flowId) + "/executions/" + executionId + "/";
        return path.startsWith(authorizedBasePath);
    }
}

