/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.secret;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SecretService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretService.class);
    private static final String SECRET_PREFIX = "SECRET_";
    private Map<String, String> decodedSecrets;

    @PostConstruct
    private void postConstruct() {
        this.decodedSecrets = System.getenv().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(SECRET_PREFIX)).mapMulti((entry, consumer) -> {
            try {
                consumer.accept(Map.entry((String)entry.getKey(), new String(Base64.getDecoder().decode((String)entry.getValue()))));
            }
            catch (Exception e) {
                log.error("Could not decode secret '{}', make sure it is Base64-encoded: {}", entry.getKey(), (Object)e.getMessage());
            }
        }).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(SECRET_PREFIX.length()).toUpperCase(), Map.Entry::getValue));
    }

    public String findSecret(String tenantId, String namespace, String key) throws IOException, IllegalVariableEvaluationException {
        return Optional.ofNullable(this.decodedSecrets.get(key.toUpperCase())).orElseThrow(() -> new IllegalVariableEvaluationException("Unable to find secret '" + key + "'. You should add it in your environment variables as 'SECRET_" + key.toUpperCase() + "' with base64-encoded value."));
    }
}

