/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers.helpers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.PartialHelper;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.serializers.helpers.FileTemplateLoader;
import java.io.IOException;
import java.util.Collections;
import javax.validation.ConstraintViolationException;

public class HandleBarDeserializer
extends StringDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Handlebars HANDLEBARS = new Handlebars().with(EscapingStrategy.NOOP).startDelimiter("[[").endDelimiter("]]").registerHelpers(PartialHelper.class).registerHelperMissing((context, options) -> {
        throw new IllegalStateException("Missing variable: " + options.helperName);
    });

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String value = p.getText();
        if (value.contains("[[") && value.contains("]]")) {
            String contextPath = String.valueOf(ctxt.findInjectableValue((Object)"flowDirectory", null, null));
            FileTemplateLoader loader = new FileTemplateLoader(contextPath, "");
            Handlebars handlebars = HANDLEBARS.with(new TemplateLoader[]{loader});
            Template template = handlebars.compileInline(value);
            try {
                return template.apply((Object)ImmutableMap.of());
            }
            catch (HandlebarsException | IOException e) {
                throw new ConstraintViolationException(Collections.singleton(ManualConstraintViolation.of(e.getMessage(), this, HandleBarDeserializer.class, "template", value)));
            }
        }
        return super.deserialize(p, ctxt);
    }
}

