/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.FlowGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.Relation;
import io.kestra.core.models.hierarchies.SubflowGraphCluster;
import io.kestra.core.models.hierarchies.SubflowGraphTask;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.services.TaskDefaultService;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.Rethrow;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GraphService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphService.class);
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private TaskDefaultService taskDefaultService;

    public FlowGraph flowGraph(Flow flow, List<String> expandedSubflows) throws IllegalVariableEvaluationException {
        return FlowGraph.of(this.of(flow, Optional.ofNullable(expandedSubflows).orElse(Collections.emptyList()), new HashMap<String, Flow>()));
    }

    public GraphCluster of(Flow flow, List<String> expandedSubflows, Map<String, Flow> flowByUid) throws IllegalVariableEvaluationException {
        return this.of(null, flow, expandedSubflows, flowByUid);
    }

    public GraphCluster of(GraphCluster baseGraph, Flow flow, List<String> expandedSubflows, Map<String, Flow> flowByUid) throws IllegalVariableEvaluationException {
        String tenantId = flow.getTenantId();
        flow = this.taskDefaultService.injectDefaults(flow);
        GraphCluster graphCluster = GraphUtils.of(baseGraph, flow, null);
        Stream<TaskToClusterReplacer> subflowToReplaceByParent = graphCluster.allNodesByParent().entrySet().stream().flatMap(entry -> {
            List<SubflowGraphTask> subflowGraphTasks = ((List)entry.getValue()).stream().filter(node -> node instanceof SubflowGraphTask && expandedSubflows.contains(node.getUid())).map(SubflowGraphTask.class::cast).toList();
            if (subflowGraphTasks.isEmpty()) {
                return Stream.empty();
            }
            return subflowGraphTasks.stream().map(subflowGraphTask -> Map.entry((GraphCluster)entry.getKey(), subflowGraphTask));
        });
        subflowToReplaceByParent.map(Rethrow.throwFunction(parentWithSubflowGraphTask -> {
            SubflowGraphTask subflowGraphTask = (SubflowGraphTask)parentWithSubflowGraphTask.getValue();
            Flow subflow = flowByUid.computeIfAbsent(subflowGraphTask.getExecutableTask().subflowId().flowUid(), uid -> this.flowRepository.findById(tenantId, subflowGraphTask.getExecutableTask().subflowId().namespace(), subflowGraphTask.getExecutableTask().subflowId().flowId(), subflowGraphTask.getExecutableTask().subflowId().revision()).orElseThrow(() -> new NoSuchElementException("Unable to find subflow " + (subflowGraphTask.getExecutableTask().subflowId().revision().isEmpty() ? subflowGraphTask.getExecutableTask().subflowId().flowUidWithoutRevision() : subflowGraphTask.getExecutableTask().subflowId().flowUid()) + " for task " + subflowGraphTask.getTask().getId())));
            subflow = this.taskDefaultService.injectDefaults(subflow);
            return new TaskToClusterReplacer((GraphCluster)parentWithSubflowGraphTask.getKey(), subflowGraphTask, this.of(new SubflowGraphCluster(subflowGraphTask.getUid(), subflowGraphTask), subflow, expandedSubflows.stream().filter(expandedSubflow -> expandedSubflow.startsWith(subflowGraphTask.getUid() + ".")).toList(), flowByUid));
        })).forEach(TaskToClusterReplacer::replace);
        return graphCluster;
    }

    private record TaskToClusterReplacer(GraphCluster parentCluster, AbstractGraph taskToReplace, GraphCluster clusterForReplacement) {
        public void replace() {
            this.parentCluster.addNode(this.clusterForReplacement, false);
            this.parentCluster.getGraph().edges().forEach(edge -> {
                if (((AbstractGraph)edge.getSource()).equals(this.taskToReplace)) {
                    this.parentCluster.addEdge(this.clusterForReplacement.getEnd(), (AbstractGraph)edge.getTarget(), (Relation)edge.getValue());
                } else if (((AbstractGraph)edge.getTarget()).equals(this.taskToReplace)) {
                    this.parentCluster.addEdge((AbstractGraph)edge.getSource(), this.clusterForReplacement.getRoot(), (Relation)edge.getValue());
                }
            });
            this.parentCluster.getGraph().removeNode(this.taskToReplace);
            if (this.taskToReplace.isError()) {
                this.clusterForReplacement.updateErrorWithChildren(true);
            }
        }
    }
}

