/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.runners.WorkerInstance;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WorkerInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerInstanceService.class);

    public static List<WorkerInstance> removeEvictedPartitions(Stream<WorkerInstance> stream, WorkerInstance incoming) {
        List<WorkerInstance> changedInstance = stream.filter(r -> !r.getWorkerUuid().toString().equals(incoming.getWorkerUuid().toString())).filter(r -> r.getWorkerGroup() == null && incoming.getWorkerGroup() == null || r.getWorkerGroup() != null && r.getWorkerGroup().equals(incoming.getWorkerGroup())).filter(r -> !Collections.disjoint(r.getPartitions() == null ? List.of() : r.getPartitions(), incoming.getPartitions() == null ? List.of() : incoming.getPartitions())).toList();
        if (!changedInstance.isEmpty()) {
            return changedInstance.stream().filter(r -> r.getPartitions() != null).peek(evictedInstance -> evictedInstance.getPartitions().removeAll(incoming.getPartitions())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

