/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class PluginUtilsService {
    protected static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    private static final Pattern PATTERN = Pattern.compile("^::(\\{.*})::$");

    public static Map<String, String> createOutputFiles(Path tempDirectory, List<String> outputFiles, Map<String, Object> additionalVars) throws IOException {
        return PluginUtilsService.createOutputFiles(tempDirectory, outputFiles, additionalVars, false);
    }

    public static Map<String, String> createOutputFiles(Path tempDirectory, List<String> outputFiles, Map<String, Object> additionalVars, Boolean isDir) throws IOException {
        ArrayList<String> outputs = new ArrayList<String>();
        if (outputFiles != null && outputFiles.size() > 0) {
            outputs.addAll(outputFiles);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (outputs.size() > 0) {
            outputs.forEach(Rethrow.throwConsumer(s -> {
                PluginUtilsService.validFilename(s);
                File tempFile = isDir != false ? Files.createTempDirectory(tempDirectory, s + "_", new FileAttribute[0]).toFile() : File.createTempFile(s + "_", null, tempDirectory.toFile());
                result.put((String)s, "{{workingDir}}/" + tempFile.getName());
            }));
            if (!isDir.booleanValue()) {
                additionalVars.put("temp", result);
            }
            additionalVars.put(isDir != false ? "outputDirs" : "outputFiles", result);
        }
        return result;
    }

    private static void validFilename(String s) {
        if (s.startsWith("./") || s.startsWith("..") || s.startsWith("/")) {
            throw new IllegalArgumentException("Invalid outputFile (only relative path is supported) for path '" + s + "'");
        }
    }

    public static Map<String, String> transformInputFiles(RunContext runContext, @NotNull Object inputFiles) throws IllegalVariableEvaluationException, JsonProcessingException {
        if (inputFiles instanceof Map) {
            return (Map)inputFiles;
        }
        if (inputFiles instanceof String) {
            TypeReference<Map<String, String>> reference = new TypeReference<Map<String, String>>(){};
            return (Map)JacksonMapper.ofJson(false).readValue(runContext.render((String)inputFiles), (TypeReference)reference);
        }
        throw new IllegalVariableEvaluationException("Invalid `files` properties with type '" + (Serializable)(inputFiles != null ? inputFiles.getClass() : "null") + "'");
    }

    public static void createInputFiles(RunContext runContext, Path workingDirectory, Map<String, String> inputFiles, Map<String, Object> additionalVars) throws IOException, IllegalVariableEvaluationException, URISyntaxException {
        if (inputFiles != null && inputFiles.size() > 0) {
            for (String fileName : inputFiles.keySet()) {
                Path subFolder;
                String finalFileName = runContext.render(fileName);
                PluginUtilsService.validFilename(finalFileName);
                File file = new File(fileName);
                if (file.getParent() != null && !(subFolder = Paths.get(workingDirectory.toAbsolutePath().toString(), new File(finalFileName).getParent())).toFile().exists()) {
                    Files.createDirectories(subFolder, new FileAttribute[0]);
                }
                String filePath = workingDirectory + "/" + finalFileName;
                String render = runContext.render(inputFiles.get(fileName), additionalVars);
                if (render.startsWith("kestra://")) {
                    InputStream inputStream = runContext.uriToInputStream(new URI(render));
                    try {
                        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(filePath));
                        try {
                            int byteRead;
                            while ((byteRead = inputStream.read()) != -1) {
                                ((OutputStream)outputStream).write(byteRead);
                            }
                            ((OutputStream)outputStream).flush();
                            continue;
                        }
                        finally {
                            ((OutputStream)outputStream).close();
                            continue;
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        continue;
                    }
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                    writer.write(render);
                }
            }
        }
    }

    public static Map<String, Object> parseOut(String line, Logger logger, RunContext runContext) {
        Matcher m = PATTERN.matcher(line);
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        if (m.find()) {
            try {
                BashCommand bashCommand = (BashCommand)MAPPER.readValue(m.group(1), BashCommand.class);
                if (bashCommand.getOutputs() != null) {
                    outputs.putAll(bashCommand.getOutputs());
                }
                if (bashCommand.getMetrics() != null) {
                    bashCommand.getMetrics().forEach(runContext::metric);
                }
            }
            catch (JsonProcessingException e) {
                logger.warn("Invalid outputs '{}'", (Object)e.getMessage(), (Object)e);
            }
        }
        return outputs;
    }

    public static class BashCommand<T> {
        private Map<String, Object> outputs;
        private List<AbstractMetricEntry<T>> metrics;

        @Generated
        public BashCommand() {
        }

        @Generated
        public Map<String, Object> getOutputs() {
            return this.outputs;
        }

        @Generated
        public List<AbstractMetricEntry<T>> getMetrics() {
            return this.metrics;
        }

        @Generated
        public void setOutputs(Map<String, Object> outputs) {
            this.outputs = outputs;
        }

        @Generated
        public void setMetrics(List<AbstractMetricEntry<T>> metrics) {
            this.metrics = metrics;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BashCommand)) {
                return false;
            }
            BashCommand other = (BashCommand)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$outputs = this.getOutputs();
            Map<String, Object> other$outputs = other.getOutputs();
            if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
                return false;
            }
            List<AbstractMetricEntry<T>> this$metrics = this.getMetrics();
            List<AbstractMetricEntry<T>> other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BashCommand;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $outputs = this.getOutputs();
            result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
            List<AbstractMetricEntry<T>> $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PluginUtilsService.BashCommand(outputs=" + this.getOutputs() + ", metrics=" + this.getMetrics() + ")";
        }
    }
}

