/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.log;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.event.Level;

@Schema(title="Fetch execution logs and store them in a file.", description="This task is useful to automate moving logs between various systems and environments")
@Plugin(examples={@Example(code={"level: INFO", "executionId: \"{{trigger.executionId}}\""}), @Example(code={"level: WARN", "executionId: \"{{execution.id}}\"", "tasksId: ", "  - \"previous_task_id\""})})
public class Fetch
extends Task
implements RunnableTask<Output> {
    @Schema(title="Filter for a specific execution", description="If not set, the task will use the ID of the current execution.")
    @PluginProperty(dynamic=true)
    private String executionId;
    @Schema(title="Filter for one or more task(s)")
    @PluginProperty
    private Collection<String> tasksId;
    @Schema(title="The lowest log level that you want to fetch")
    @PluginProperty
    private Level level;

    @Override
    public Output run(RunContext runContext) throws Exception {
        String executionId = this.executionId != null ? runContext.render(this.executionId) : (String)new HashMap((Map)runContext.getVariables().get("execution")).get("id");
        LogRepositoryInterface logRepository = (LogRepositoryInterface)runContext.getApplicationContext().getBean(LogRepositoryInterface.class);
        File tempFile = runContext.tempFile(".ion").toFile();
        AtomicLong count = new AtomicLong();
        Map flowVars = (Map)runContext.getVariables().get("flow");
        String tenantId = (String)flowVars.get("tenantId");
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            if (this.tasksId != null) {
                for (String taskId : this.tasksId) {
                    logRepository.findByExecutionIdAndTaskId(tenantId, executionId, taskId, this.level).forEach(Rethrow.throwConsumer(log -> {
                        count.incrementAndGet();
                        FileSerde.write(output, log);
                    }));
                }
            } else {
                logRepository.findByExecutionId(tenantId, executionId, this.level).forEach(Rethrow.throwConsumer(log -> {
                    count.incrementAndGet();
                    FileSerde.write(output, log);
                }));
            }
        }
        return Output.builder().uri(runContext.putTempFile(tempFile)).size(count.get()).build();
    }

    @Generated
    private static Level $default$level() {
        return Level.INFO;
    }

    @Generated
    protected Fetch(FetchBuilder<?, ?> b) {
        super(b);
        this.executionId = b.executionId;
        this.tasksId = b.tasksId;
        this.level = b.level$set ? b.level$value : Fetch.$default$level();
    }

    @Generated
    public static FetchBuilder<?, ?> builder() {
        return new FetchBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Fetch(super=" + super.toString() + ", executionId=" + this.getExecutionId() + ", tasksId=" + this.getTasksId() + ", level=" + this.getLevel() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fetch)) {
            return false;
        }
        Fetch other = (Fetch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        Collection<String> this$tasksId = this.getTasksId();
        Collection<String> other$tasksId = other.getTasksId();
        if (this$tasksId == null ? other$tasksId != null : !((Object)this$tasksId).equals(other$tasksId)) {
            return false;
        }
        Level this$level = this.getLevel();
        Level other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fetch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        Collection<String> $tasksId = this.getTasksId();
        result = result * 59 + ($tasksId == null ? 43 : ((Object)$tasksId).hashCode());
        Level $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public Collection<String> getTasksId() {
        return this.tasksId;
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public Fetch() {
        this.level = Fetch.$default$level();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The number of fetched rows")
        private Long size;
        @Schema(title="Internal storage uri of stored results", description="Stored as Amazon ION file in a row per row format.")
        private URI uri;

        @ConstructorProperties(value={"size", "uri"})
        @Generated
        Output(Long size, URI uri) {
            this.size = size;
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long size;
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.size, this.uri);
            }

            @Generated
            public String toString() {
                return "Fetch.Output.OutputBuilder(size=" + this.size + ", uri=" + this.uri + ")";
            }
        }
    }

    @Generated
    public static abstract class FetchBuilder<C extends Fetch, B extends FetchBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String executionId;
        @Generated
        private Collection<String> tasksId;
        @Generated
        private boolean level$set;
        @Generated
        private Level level$value;

        @Generated
        public B executionId(String executionId) {
            this.executionId = executionId;
            return (B)this.self();
        }

        @Generated
        public B tasksId(Collection<String> tasksId) {
            this.tasksId = tasksId;
            return (B)this.self();
        }

        @Generated
        public B level(Level level) {
            this.level$value = level;
            this.level$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Fetch.FetchBuilder(super=" + super.toString() + ", executionId=" + this.executionId + ", tasksId=" + this.tasksId + ", level$value=" + this.level$value + ")";
        }
    }

    @Generated
    private static final class FetchBuilderImpl
    extends FetchBuilder<Fetch, FetchBuilderImpl> {
        @Generated
        private FetchBuilderImpl() {
        }

        @Override
        @Generated
        protected FetchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Fetch build() {
            return new Fetch(this);
        }
    }
}

