/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Allow to create files in the local filesystem or to send files from the local filesystem to the internal storage.", description="This task should be used with the WorkingDirectory task to be able to access the same local filesystem within multiple tasks. Note that this task cannot be skipped, so setting `disabled: true` will not work on this task.")
@Plugin(examples={@Example(full=true, title="Output local files created in a Python task and load them to S3", code={"id: outputsFromPythonTask\nnamespace: dev\n\ntasks:\n  - id: wdir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    tasks:\n      - id: cloneRepository\n        type: io.kestra.plugin.git.Clone\n        url: https://github.com/kestra-io/examples\n        branch: main\n\n      - id: gitPythonScripts\n        type: io.kestra.plugin.scripts.python.Commands\n        warningOnStdErr: false\n        runner: DOCKER\n        docker:\n          image: ghcr.io/kestra-io/pydata:latest\n        beforeCommands:\n          - pip install faker > /dev/null\n        commands:\n          - python scripts/etl_script.py\n          - python scripts/generate_orders.py\n\n      - id: outputFile\n        type: io.kestra.core.tasks.storages.LocalFiles\n        outputs:\n          - orders.csv\n          - \"*.parquet\"\n\n  - id: loadCsvToS3\n    type: io.kestra.plugin.aws.s3.Upload\n    accessKeyId: \"{{secret('AWS_ACCESS_KEY_ID')}}\"\n    secretKeyId: \"{{secret('AWS_SECRET_ACCESS_KEY')}}\"\n    region: eu-central-1\n    bucket: kestraio\n    key: stage/orders.csv\n    from: \"{{outputs.outputFile.uris['orders.csv']}}\"\n    disabled: true\n"}), @Example(full=true, title="Create a local file that will be accessible to a bash task", code={"id: \"local-files\"\nnamespace: \"io.kestra.tests\"\n\ntasks:\n  - id: workingDir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    tasks:\n    - id: inputFiles\n      type: io.kestra.core.tasks.storages.LocalFiles\n      inputs:\n        hello.txt: \"Hello World\\n\"\n        address.json: \"{{ outputs.myTaskId.uri }}\"\n    - id: bash\n      type: io.kestra.plugin.scripts.shell.Commands\n      commands:\n        - cat hello.txt\n"}), @Example(full=true, title="Send local files to Kestra's internal storage", code={"id: \"local-files\"\nnamespace: \"io.kestra.tests\"\n\ntasks:\n  - id: workingDir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    tasks:\n    - id: bash\n      type: io.kestra.plugin.scripts.shell.Commands\n      commands:\n        - mkdir -p sub/dir\n        - echo \"Hello from Bash\" >> sub/dir/bash1.txt\n        - echo \"Hello from Bash\" >> sub/dir/bash2.txt\n    - id: outputFiles\n      type: io.kestra.core.tasks.storages.LocalFiles\n      outputs:\n        - sub/**\n"})})
public class LocalFiles
extends Task
implements RunnableTask<LocalFilesOutput> {
    @Schema(title="The files to create on the local filesystem. Can be a map or a JSON object.", anyOf={Map.class, String.class})
    @PluginProperty(dynamic=true)
    private Object inputs;
    @Schema(title="The files from the local filesystem to send to the internal storage.", description="Must be a list of [Glob](https://en.wikipedia.org/wiki/Glob_(programming)) expressions relative to the current working directory, some examples: `my-dir/**`, `my-dir/*/**` or `my-dir/my-file.txt`")
    @PluginProperty(dynamic=true)
    private List<String> outputs;

    @Override
    public LocalFilesOutput run(RunContext runContext) throws Exception {
        FilesService.inputFiles(runContext, this.inputs);
        Map<String, URI> outputFiles = FilesService.outputFiles(runContext, this.outputs);
        return LocalFilesOutput.builder().uris(outputFiles).build();
    }

    @Generated
    protected LocalFiles(LocalFilesBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.outputs = b.outputs;
    }

    @Generated
    public static LocalFilesBuilder<?, ?> builder() {
        return new LocalFilesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "LocalFiles(super=" + super.toString() + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalFiles)) {
            return false;
        }
        LocalFiles other = (LocalFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$inputs = this.getInputs();
        Object other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        List<String> this$outputs = this.getOutputs();
        List<String> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalFiles;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        List<String> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        return result;
    }

    @Generated
    public Object getInputs() {
        return this.inputs;
    }

    @Generated
    public List<String> getOutputs() {
        return this.outputs;
    }

    @Generated
    public LocalFiles() {
    }

    public static class LocalFilesOutput
    implements Output {
        @Schema(title="The URI of the files that have been sent to the internal storage")
        private Map<String, URI> uris;

        @ConstructorProperties(value={"uris"})
        @Generated
        LocalFilesOutput(Map<String, URI> uris) {
            this.uris = uris;
        }

        @Generated
        public static LocalFilesOutputBuilder builder() {
            return new LocalFilesOutputBuilder();
        }

        @Generated
        public Map<String, URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class LocalFilesOutputBuilder {
            @Generated
            private Map<String, URI> uris;

            @Generated
            LocalFilesOutputBuilder() {
            }

            @Generated
            public LocalFilesOutputBuilder uris(Map<String, URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public LocalFilesOutput build() {
                return new LocalFilesOutput(this.uris);
            }

            @Generated
            public String toString() {
                return "LocalFiles.LocalFilesOutput.LocalFilesOutputBuilder(uris=" + this.uris + ")";
            }
        }
    }

    @Generated
    public static abstract class LocalFilesBuilder<C extends LocalFiles, B extends LocalFilesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object inputs;
        @Generated
        private List<String> outputs;

        @Generated
        public B inputs(Object inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B outputs(List<String> outputs) {
            this.outputs = outputs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LocalFiles.LocalFilesBuilder(super=" + super.toString() + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ")";
        }
    }

    @Generated
    private static final class LocalFilesBuilderImpl
    extends LocalFilesBuilder<LocalFiles, LocalFilesBuilderImpl> {
        @Generated
        private LocalFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected LocalFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LocalFiles build() {
            return new LocalFiles(this);
        }
    }
}

