/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.exceptions.InternalException;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Locale;

public class DateUtils {
    public static ZonedDateTime parseZonedDateTime(String render) throws InternalException {
        ZonedDateTime currentDate;
        try {
            currentDate = ZonedDateTime.parse(render);
        }
        catch (DateTimeException e) {
            throw new InternalException(e);
        }
        return currentDate;
    }

    public static OffsetTime parseOffsetTime(String render) throws InternalException {
        OffsetTime currentTime;
        try {
            currentTime = OffsetTime.parse(render);
        }
        catch (DateTimeException e) {
            throw new InternalException(e);
        }
        return currentTime;
    }

    public static LocalDate parseLocalDate(String render) throws InternalException {
        LocalDate currentDate;
        try {
            currentDate = LocalDate.parse(render);
        }
        catch (DateTimeException e) {
            currentDate = DateUtils.parseZonedDateTime(render).toLocalDate();
        }
        return currentDate;
    }

    public static GroupType groupByType(Duration duration) {
        if (duration.toDays() > (long)GroupValue.MONTH.getValue()) {
            return GroupType.MONTH;
        }
        if (duration.toDays() > (long)GroupValue.WEEK.getValue()) {
            return GroupType.WEEK;
        }
        if (duration.toDays() > (long)GroupValue.DAY.getValue()) {
            return GroupType.DAY;
        }
        if (duration.toHours() > (long)GroupValue.HOUR.getValue()) {
            return GroupType.HOUR;
        }
        return GroupType.MINUTE;
    }

    public static enum GroupValue {
        MONTH(365),
        WEEK(180),
        DAY(1),
        HOUR(6);

        private final int value;

        private GroupValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum GroupType {
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;


        public String val() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

