/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.ThreadMainFactoryBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Singleton
public class ExecutorsUtils {
    @Inject
    private ThreadMainFactoryBuilder threadFactoryBuilder;
    @Inject
    private MeterRegistry meterRegistry;

    public ExecutorService cachedThreadPool(String name) {
        return this.wrap(name, Executors.newCachedThreadPool(this.threadFactoryBuilder.build(name + "_%d")));
    }

    public ExecutorService maxCachedThreadPool(int maxThread, String name) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(maxThread, maxThread, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.threadFactoryBuilder.build(name + "_%d"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return this.wrap(name, threadPoolExecutor);
    }

    public ExecutorService fixedThreadPool(int thread, String name) {
        return this.wrap(name, Executors.newFixedThreadPool(thread, this.threadFactoryBuilder.build(name + "_%d")));
    }

    public ExecutorService singleThreadExecutor(String name) {
        return this.wrap(name, Executors.newSingleThreadExecutor(this.threadFactoryBuilder.build(name + "_%d")));
    }

    public ExecutorService singleThreadScheduledExecutor(String name) {
        return this.wrap(name, Executors.newSingleThreadScheduledExecutor(this.threadFactoryBuilder.build(name + "_%d")));
    }

    private ExecutorService wrap(String name, ExecutorService executorService) {
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)executorService, (String)name, (Tag[])new Tag[0]);
    }
}

