/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.contexts;

import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.RegisteredPlugin;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KestraClassLoader
extends ClassLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KestraClassLoader.class);
    private static KestraClassLoader INSTANCE;
    private PluginRegistry pluginRegistry;

    private KestraClassLoader(ClassLoader classLoader) {
        super("kestra", classLoader);
    }

    public static KestraClassLoader create(ClassLoader classLoader) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Can't init classLoader, already init");
        }
        INSTANCE = new KestraClassLoader(classLoader);
        return INSTANCE;
    }

    public static boolean isInit() {
        return INSTANCE != null;
    }

    public static KestraClassLoader instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("ClassLoader is not init for now.");
        }
        return INSTANCE;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public void setPluginRegistry(PluginRegistry registry) {
        this.pluginRegistry = registry;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.pluginRegistry == null) {
            return super.loadClass(name, resolve);
        }
        Optional<RegisteredPlugin> pluginSearch = this.pluginRegistry.find(name);
        if (pluginSearch.isPresent()) {
            RegisteredPlugin plugin = pluginSearch.get();
            if (log.isTraceEnabled()) {
                log.trace("Class '{}' found on '{}' for plugin '{}'", new Object[]{name, plugin.getClassLoader().getName(), plugin.getExternalPlugin().getLocation()});
            }
            return plugin.getClassLoader().loadClass(name);
        }
        return super.loadClass(name, resolve);
    }
}

