/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.LogHelper;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.docs.ClassPluginDocumentation;
import io.kestra.core.docs.Document;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.docs.PluginDocumentation;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.runners.handlebars.helpers.DateHelper;
import io.kestra.core.runners.handlebars.helpers.JsonHelper;
import io.kestra.core.runners.handlebars.helpers.OtherBooleansHelper;
import io.kestra.core.runners.handlebars.helpers.OtherStringsHelper;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Slugify;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class DocumentationGenerator {
    private static final Handlebars handlebars = new Handlebars().with(EscapingStrategy.NOOP).registerHelpers(ConditionalHelpers.class).registerHelpers(EachHelper.class).registerHelpers(LogHelper.class).registerHelpers(StringHelpers.class).registerHelpers(OtherStringsHelper.class).registerHelpers(OtherBooleansHelper.class).registerHelper("definitionName", (context, options) -> {
        String s = StringUtils.substringAfterLast((String)context.toString(), (String)".");
        if (s.contains("-")) {
            String s1 = StringUtils.substringAfter((String)s, (String)"-");
            try {
                Integer.parseInt(s1);
            }
            catch (NumberFormatException e) {
                s = s1;
            }
        }
        return s;
    }).registerHelpers(UnlessHelper.class).registerHelpers(WithHelper.class).registerHelpers(DateHelper.class).registerHelpers(JsonHelper.class);
    @Inject
    JsonSchemaGenerator jsonSchemaGenerator;

    public List<Document> generate(RegisteredPlugin registeredPlugin) throws IOException {
        ArrayList<Document> result = new ArrayList<Document>();
        result.addAll(DocumentationGenerator.index(registeredPlugin));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getTasks(), Task.class, "tasks"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getTriggers(), AbstractTrigger.class, "triggers"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getConditions(), Condition.class, "conditions"));
        return result;
    }

    private static List<Document> index(RegisteredPlugin plugin) throws IOException {
        PluginDocumentation pluginDocumentation = PluginDocumentation.of(plugin);
        if (pluginDocumentation.getClassPlugins().size() == 0) {
            return Collections.emptyList();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (plugin.getManifest() != null) {
            builder.put((Object)"title", (Object)plugin.getManifest().getMainAttributes().getValue("X-Kestra-Title"));
            builder.put((Object)"group", (Object)plugin.getManifest().getMainAttributes().getValue("X-Kestra-Group"));
            builder.put((Object)"docs", JacksonMapper.toMap(pluginDocumentation));
        }
        return Collections.singletonList(new Document(DocumentationGenerator.docPath(plugin), DocumentationGenerator.render("index", (Map<String, Object>)builder.build()), null));
    }

    private <T> List<Document> generate(RegisteredPlugin registeredPlugin, List<Class<? extends T>> cls, Class<T> baseCls, String type) {
        return cls.stream().map(r -> ClassPluginDocumentation.of(this.jsonSchemaGenerator, registeredPlugin, r, baseCls)).map(pluginDocumentation -> {
            try {
                return new Document(DocumentationGenerator.docPath(registeredPlugin, type, pluginDocumentation), DocumentationGenerator.render(pluginDocumentation), pluginDocumentation.getIcon());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public static String icon(RegisteredPlugin plugin, Class<?> cls) {
        InputStream resourceAsStream = Stream.of(plugin.getClassLoader().getResourceAsStream("icons/" + cls.getName() + ".svg"), plugin.getClassLoader().getResourceAsStream("icons/" + cls.getPackageName() + ".svg")).filter(Objects::nonNull).findFirst().orElse(null);
        if (resourceAsStream != null) {
            return Base64.getEncoder().encodeToString(IOUtils.toString((InputStream)resourceAsStream, (Charset)Charsets.UTF_8).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    private static <T> String docPath(RegisteredPlugin registeredPlugin) {
        String pluginName = Slugify.of(registeredPlugin.title());
        return pluginName + "/README.md";
    }

    private static <T> String docPath(RegisteredPlugin registeredPlugin, String type, ClassPluginDocumentation<T> classPluginDocumentation) {
        String pluginName = Slugify.of(registeredPlugin.title());
        return pluginName + "/" + type + "/" + (String)(classPluginDocumentation.getSubGroup() != null ? classPluginDocumentation.getSubGroup() + "/" : "") + classPluginDocumentation.getCls() + ".md";
    }

    public static <T> String render(ClassPluginDocumentation<T> classPluginDocumentation) throws IOException {
        return DocumentationGenerator.render("task", JacksonMapper.toMap(classPluginDocumentation));
    }

    public static <T> String render(String templateName, Map<String, Object> vars) throws IOException {
        String hbsTemplate = IOUtils.toString((InputStream)Objects.requireNonNull(DocumentationGenerator.class.getClassLoader().getResourceAsStream("docs/" + templateName + ".hbs")), (Charset)Charsets.UTF_8);
        Template template = handlebars.compileInline(hbsTemplate);
        String renderer = template.apply(vars);
        Pattern pattern = Pattern.compile("`\\{\\{(.*?)\\}\\}`", 8);
        renderer = pattern.matcher(renderer).replaceAll("<code v-pre>{{ $1 }}</code>");
        return renderer;
    }
}

