/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.naming.DefaultSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationModule;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.serializers.JacksonMapper;
import io.micronaut.core.annotation.Nullable;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class JsonSchemaGenerator {
    Map<Class<?>, Object> defaultInstances = new HashMap();

    public <T> Map<String, Object> properties(Class<T> base, Class<? extends T> cls) {
        return this.generate(cls, base);
    }

    public <T> Map<String, Object> outputs(Class<T> base, Class<? extends T> cls) {
        ArrayList<Class<T>> superClass = new ArrayList<Class<T>>();
        for (Class<T> c2 = cls; c2 != null && c2 != base; c2 = c2.getSuperclass()) {
            superClass.add(c2);
        }
        return superClass.stream().flatMap(r -> Arrays.stream(r.getGenericInterfaces())).filter(type -> type instanceof ParameterizedType).map(type -> (ParameterizedType)type).flatMap(parameterizedType -> Arrays.stream(parameterizedType.getActualTypeArguments())).filter(type -> type instanceof Class).map(type -> (Class)type).filter(Output.class::isAssignableFrom).findFirst().map(c -> this.generate((Class)c, null)).orElse((Map)ImmutableMap.of());
    }

    protected <T> void build(SchemaGeneratorConfigBuilder builder, Class<? extends T> cls) {
        builder.with((Module)new JacksonModule()).with((Module)new JavaxValidationModule(new JavaxValidationOption[]{JavaxValidationOption.NOT_NULLABLE_FIELD_IS_REQUIRED, JavaxValidationOption.INCLUDE_PATTERN_EXPRESSIONS})).with((Module)new Swagger2Module()).with(Option.DEFINITIONS_FOR_ALL_OBJECTS, new Option[0]).with(Option.DEFINITION_FOR_MAIN_SCHEMA, new Option[0]).with(Option.PLAIN_DEFINITION_KEYS, new Option[0]).with(Option.ALLOF_CLEANUP_AT_THE_END, new Option[0]);
        builder.forFields().withDefaultResolver(this::defaults);
        builder.forTypesInGeneral().withDefinitionNamingStrategy((SchemaDefinitionNamingStrategy)new DefaultSchemaDefinitionNamingStrategy(){

            public String getDefinitionNameForKey(DefinitionKey key, SchemaGenerationContext context) {
                TypeContext typeContext = context.getTypeContext();
                ResolvedType type = key.getType();
                return typeContext.getFullTypeDescription(type);
            }

            public String adjustNullableName(DefinitionKey key, String definitionName, SchemaGenerationContext context) {
                return definitionName;
            }
        });
        builder.forTypesInGeneral().withCustomDefinitionProvider(new CustomDefinitionProviderV2(){

            public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
                if (javaType.isInstanceOf(Map.class) || javaType.isInstanceOf(Enum.class)) {
                    ObjectNode definition = context.createStandardDefinition(javaType, (CustomDefinitionProviderV2)this);
                    return new CustomDefinition(definition, true);
                }
                if (javaType.isInstanceOf(Duration.class)) {
                    ObjectNode definitionReference = context.createDefinitionReference(context.getTypeContext().resolve(String.class, new Type[0])).put("format", "duration");
                    return new CustomDefinition(definitionReference, true);
                }
                return null;
            }
        });
        builder.forFields().withInstanceAttributeOverride((memberAttributes, member, context) -> {
            Schema schema;
            PluginProperty pluginPropertyAnnotation = (PluginProperty)member.getAnnotation(PluginProperty.class);
            if (pluginPropertyAnnotation != null) {
                memberAttributes.put("$dynamic", pluginPropertyAnnotation.dynamic());
            }
            if ((schema = (Schema)member.getAnnotation(Schema.class)) != null && schema.deprecated()) {
                memberAttributes.put("$deprecated", true);
            }
        });
        builder.forTypesInGeneral().withTypeAttributeOverride((collectedTypeAttributes, scope, context) -> {
            List examples;
            Plugin pluginAnnotation = scope.getType().getErasedType().getAnnotation(Plugin.class);
            if (pluginAnnotation != null && (examples = Arrays.stream(pluginAnnotation.examples()).map(example -> context.getGeneratorConfig().createObjectNode().put("full", example.full()).put("code", String.join((CharSequence)"\n", example.code())).put("lang", example.lang()).put("title", example.title())).collect(Collectors.toList())).size() > 0) {
                collectedTypeAttributes.set("$examples", (JsonNode)context.getGeneratorConfig().createArrayNode().addAll(examples));
            }
        });
        builder.forFields().withAdditionalPropertiesResolver(target -> {
            PluginProperty pluginPropertyAnnotation = (PluginProperty)target.getAnnotation(PluginProperty.class);
            if (pluginPropertyAnnotation != null) {
                return pluginPropertyAnnotation.additionalProperties();
            }
            return Object.class;
        });
    }

    protected <T> Map<String, Object> generate(Class<? extends T> cls, @Nullable Class<T> base) {
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2019_09, OptionPreset.PLAIN_JSON);
        this.build(builder, cls);
        builder.forFields().withIgnoreCheck(fieldScope -> base != null && fieldScope.getDeclaringType().getTypeName().equals(base.getName()));
        SchemaGeneratorConfig schemaGeneratorConfig = builder.build();
        SchemaGenerator generator = new SchemaGenerator(schemaGeneratorConfig);
        try {
            ObjectNode objectNode = generator.generateSchema(cls, new Type[0]);
            return JacksonMapper.toMap(this.extractMainRef(objectNode));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to generate jsonschema for '" + cls.getName() + "'", e);
        }
    }

    protected Object defaults(FieldScope target) {
        Object instance;
        if (target.getOverriddenType() != null) {
            return null;
        }
        Class baseCls = ((ResolvedField)target.getMember()).getDeclaringType().getErasedType();
        if (Modifier.isAbstract(baseCls.getModifiers())) {
            Class abstractBaseCls = baseCls;
            Optional<Map.Entry> derivedOne = this.defaultInstances.entrySet().stream().filter(e -> !Modifier.isAbstract(((Class)e.getKey()).getModifiers())).filter(e -> abstractBaseCls.isAssignableFrom((Class)e.getKey())).findFirst();
            if (derivedOne.isPresent()) {
                this.defaultInstances.put(baseCls, derivedOne.get());
                baseCls = (Class)derivedOne.get().getKey();
            }
        }
        if (!this.defaultInstances.containsKey(baseCls)) {
            this.defaultInstances.put(baseCls, this.buildDefaultInstance(baseCls));
        }
        return (instance = this.defaultInstances.get(baseCls)) == null ? null : this.defaultValue(instance, baseCls, target.getName());
    }

    private ObjectNode extractMainRef(ObjectNode objectNode) {
        TextNode ref = (TextNode)objectNode.get("$ref");
        ObjectNode defs = (ObjectNode)objectNode.get("$defs");
        if (ref == null) {
            throw new IllegalArgumentException("Missing $ref");
        }
        String mainClassName = ref.asText().substring(ref.asText().lastIndexOf("/") + 1);
        if (mainClassName.endsWith("-2")) {
            mainClassName = mainClassName.substring(0, mainClassName.length() - 2);
            JsonNode mainClassDef = defs.get(mainClassName + "-1");
            this.addMainRefProperties(mainClassDef, objectNode);
            defs.remove(mainClassName + "-1");
            defs.remove(mainClassName + "-2");
        } else {
            JsonNode mainClassDef = defs.get(mainClassName);
            this.addMainRefProperties(mainClassDef, objectNode);
            defs.remove(mainClassName);
        }
        objectNode.remove("$ref");
        return objectNode;
    }

    private void addMainRefProperties(JsonNode mainClassDef, ObjectNode objectNode) {
        objectNode.set("properties", mainClassDef.get("properties"));
        if (mainClassDef.has("required")) {
            objectNode.set("required", mainClassDef.get("required"));
        }
        if (mainClassDef.has("title")) {
            objectNode.set("title", mainClassDef.get("title"));
        }
        if (mainClassDef.has("description")) {
            objectNode.set("description", mainClassDef.get("description"));
        }
        if (mainClassDef.has("$examples")) {
            objectNode.set("$examples", mainClassDef.get("$examples"));
        }
    }

    private Object buildDefaultInstance(Class<?> cls) {
        try {
            Method builderMethod = cls.getMethod("builder", new Class[0]);
            Object builder = builderMethod.invoke(null, new Object[0]);
            Method build = builder.getClass().getMethod("build", new Class[0]);
            build.setAccessible(true);
            return build.invoke(builder, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Object defaultValue(Object instance, Class<?> cls, String fieldName) {
        try {
            Method field = cls.getMethod("get" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1), new Class[0]);
            field.setAccessible(true);
            return field.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException field) {
            try {
                Method field2 = cls.getMethod("is" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1), new Class[0]);
                field2.setAccessible(true);
                return field2.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                return null;
            }
        }
    }
}

