/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.micronaut.core.annotation.Introspected;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Introspected
@JsonDeserialize(builder=FlowUsageBuilderImpl.class)
public class FlowUsage {
    private final Integer count;
    private final Long namespacesCount;
    private final Map<String, Long> taskTypeCount;
    private final Map<String, Long> triggerTypeCount;

    public static FlowUsage of(FlowRepositoryInterface flowRepository) {
        List allFlows = flowRepository.findAll().stream().filter(flow -> !flow.getNamespace().startsWith("io.kestra.demo")).collect(Collectors.toList());
        return ((FlowUsageBuilder)((FlowUsageBuilder)((FlowUsageBuilder)((FlowUsageBuilder)FlowUsage.builder().count(allFlows.size())).namespacesCount(allFlows.stream().map(Flow::getNamespace).distinct().count())).taskTypeCount(allFlows.stream().flatMap(f -> f.allTasks().map(Task::getType)).collect(Collectors.groupingBy(f -> f, Collectors.counting())))).triggerTypeCount(allFlows.stream().flatMap(f -> f.getTriggers() != null ? f.getTriggers().stream().map(AbstractTrigger::getType) : Stream.empty()).collect(Collectors.groupingBy(f -> f, Collectors.counting())))).build();
    }

    @Generated
    protected FlowUsage(FlowUsageBuilder<?, ?> b) {
        this.count = b.count;
        this.namespacesCount = b.namespacesCount;
        this.taskTypeCount = b.taskTypeCount;
        this.triggerTypeCount = b.triggerTypeCount;
    }

    @Generated
    public static FlowUsageBuilder<?, ?> builder() {
        return new FlowUsageBuilderImpl();
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public Long getNamespacesCount() {
        return this.namespacesCount;
    }

    @Generated
    public Map<String, Long> getTaskTypeCount() {
        return this.taskTypeCount;
    }

    @Generated
    public Map<String, Long> getTriggerTypeCount() {
        return this.triggerTypeCount;
    }

    @Generated
    public static abstract class FlowUsageBuilder<C extends FlowUsage, B extends FlowUsageBuilder<C, B>> {
        @Generated
        private Integer count;
        @Generated
        private Long namespacesCount;
        @Generated
        private Map<String, Long> taskTypeCount;
        @Generated
        private Map<String, Long> triggerTypeCount;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B count(Integer count) {
            this.count = count;
            return this.self();
        }

        @Generated
        public B namespacesCount(Long namespacesCount) {
            this.namespacesCount = namespacesCount;
            return this.self();
        }

        @Generated
        public B taskTypeCount(Map<String, Long> taskTypeCount) {
            this.taskTypeCount = taskTypeCount;
            return this.self();
        }

        @Generated
        public B triggerTypeCount(Map<String, Long> triggerTypeCount) {
            this.triggerTypeCount = triggerTypeCount;
            return this.self();
        }

        @Generated
        public String toString() {
            return "FlowUsage.FlowUsageBuilder(count=" + this.count + ", namespacesCount=" + this.namespacesCount + ", taskTypeCount=" + this.taskTypeCount + ", triggerTypeCount=" + this.triggerTypeCount + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class FlowUsageBuilderImpl
    extends FlowUsageBuilder<FlowUsage, FlowUsageBuilderImpl> {
        @Generated
        private FlowUsageBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowUsageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowUsage build() {
            return new FlowUsage(this);
        }
    }
}

