/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.micronaut.core.annotation.Introspected;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;

@Introspected
@JsonDeserialize(builder=HostUsageBuilderImpl.class)
public class HostUsage {
    private final String uuid;
    private final Hardware hardware;
    private final Os os;
    private final Jvm jvm;

    public static HostUsage of() {
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        CentralProcessor processor = hardware.getProcessor();
        ComputerSystem computerSystem = hardware.getComputerSystem();
        String vendor = operatingSystem.getManufacturer();
        String processorSerialNumber = computerSystem.getSerialNumber();
        if (processorSerialNumber.equals("unknown")) {
            processorSerialNumber = String.join((CharSequence)"-", computerSystem.getManufacturer(), computerSystem.getModel(), computerSystem.getBaseboard().getModel());
        }
        String hardwareUUID = computerSystem.getHardwareUUID();
        String processorIdentifier = processor.getProcessorIdentifier().getIdentifier();
        String processorsCount = String.valueOf(processor.getLogicalProcessorCount());
        String hostUuid = Stream.of(vendor, processorSerialNumber, hardwareUUID, processorIdentifier, processorsCount).filter(Objects::nonNull).filter(s -> !s.equals("unknown")).map(s -> String.format("%08x", s.hashCode())).collect(Collectors.joining("-"));
        return ((HostUsageBuilder)((HostUsageBuilder)((HostUsageBuilder)((HostUsageBuilder)HostUsage.builder().uuid(hostUuid)).hardware((Hardware)((Hardware.HardwareBuilder)((Hardware.HardwareBuilder)((Hardware.HardwareBuilder)((Hardware.HardwareBuilder)((Hardware.HardwareBuilder)((Hardware.HardwareBuilder)Hardware.builder().logicalProcessorCount(processor.getLogicalProcessorCount())).physicalProcessorCount(processor.getPhysicalProcessorCount())).maxFreq(processor.getMaxFreq())).memory(hardware.getMemory().getTotal())).knownVmMacAddr(hardware.getNetworkIFs().stream().anyMatch(NetworkIF::isKnownVmMacAddr))).knownDockerMacAddr(hardware.getNetworkIFs().stream().anyMatch(networkIF -> networkIF.getMacaddr().startsWith("02:42:ac")))).build())).os((Os)((Os.OsBuilder)((Os.OsBuilder)((Os.OsBuilder)((Os.OsBuilder)Os.builder().family(operatingSystem.getFamily())).version(operatingSystem.getVersionInfo().getVersion())).codeName(operatingSystem.getVersionInfo().getCodeName())).buildNumber(operatingSystem.getVersionInfo().getBuildNumber())).build())).jvm((Jvm)((Jvm.JvmBuilder)((Jvm.JvmBuilder)((Jvm.JvmBuilder)Jvm.builder().name(ManagementFactory.getRuntimeMXBean().getVmName())).vendor(ManagementFactory.getRuntimeMXBean().getVmVendor())).version(ManagementFactory.getRuntimeMXBean().getVmVersion())).build())).build();
    }

    @Generated
    protected HostUsage(HostUsageBuilder<?, ?> b) {
        this.uuid = b.uuid;
        this.hardware = b.hardware;
        this.os = b.os;
        this.jvm = b.jvm;
    }

    @Generated
    public static HostUsageBuilder<?, ?> builder() {
        return new HostUsageBuilderImpl();
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Hardware getHardware() {
        return this.hardware;
    }

    @Generated
    public Os getOs() {
        return this.os;
    }

    @Generated
    public Jvm getJvm() {
        return this.jvm;
    }

    @Generated
    public static abstract class HostUsageBuilder<C extends HostUsage, B extends HostUsageBuilder<C, B>> {
        @Generated
        private String uuid;
        @Generated
        private Hardware hardware;
        @Generated
        private Os os;
        @Generated
        private Jvm jvm;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B uuid(String uuid) {
            this.uuid = uuid;
            return this.self();
        }

        @Generated
        public B hardware(Hardware hardware) {
            this.hardware = hardware;
            return this.self();
        }

        @Generated
        public B os(Os os) {
            this.os = os;
            return this.self();
        }

        @Generated
        public B jvm(Jvm jvm) {
            this.jvm = jvm;
            return this.self();
        }

        @Generated
        public String toString() {
            return "HostUsage.HostUsageBuilder(uuid=" + this.uuid + ", hardware=" + this.hardware + ", os=" + this.os + ", jvm=" + this.jvm + ")";
        }
    }

    @Introspected
    @JsonDeserialize(builder=HardwareBuilderImpl.class)
    public static class Hardware {
        private final int logicalProcessorCount;
        private final long physicalProcessorCount;
        private final long maxFreq;
        private final long memory;
        private final boolean knownVmMacAddr;
        private final boolean knownDockerMacAddr;

        @Generated
        protected Hardware(HardwareBuilder<?, ?> b) {
            this.logicalProcessorCount = b.logicalProcessorCount;
            this.physicalProcessorCount = b.physicalProcessorCount;
            this.maxFreq = b.maxFreq;
            this.memory = b.memory;
            this.knownVmMacAddr = b.knownVmMacAddr;
            this.knownDockerMacAddr = b.knownDockerMacAddr;
        }

        @Generated
        public static HardwareBuilder<?, ?> builder() {
            return new HardwareBuilderImpl();
        }

        @Generated
        public int getLogicalProcessorCount() {
            return this.logicalProcessorCount;
        }

        @Generated
        public long getPhysicalProcessorCount() {
            return this.physicalProcessorCount;
        }

        @Generated
        public long getMaxFreq() {
            return this.maxFreq;
        }

        @Generated
        public long getMemory() {
            return this.memory;
        }

        @Generated
        public boolean isKnownVmMacAddr() {
            return this.knownVmMacAddr;
        }

        @Generated
        public boolean isKnownDockerMacAddr() {
            return this.knownDockerMacAddr;
        }

        @Generated
        public static abstract class HardwareBuilder<C extends Hardware, B extends HardwareBuilder<C, B>> {
            @Generated
            private int logicalProcessorCount;
            @Generated
            private long physicalProcessorCount;
            @Generated
            private long maxFreq;
            @Generated
            private long memory;
            @Generated
            private boolean knownVmMacAddr;
            @Generated
            private boolean knownDockerMacAddr;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B logicalProcessorCount(int logicalProcessorCount) {
                this.logicalProcessorCount = logicalProcessorCount;
                return this.self();
            }

            @Generated
            public B physicalProcessorCount(long physicalProcessorCount) {
                this.physicalProcessorCount = physicalProcessorCount;
                return this.self();
            }

            @Generated
            public B maxFreq(long maxFreq) {
                this.maxFreq = maxFreq;
                return this.self();
            }

            @Generated
            public B memory(long memory) {
                this.memory = memory;
                return this.self();
            }

            @Generated
            public B knownVmMacAddr(boolean knownVmMacAddr) {
                this.knownVmMacAddr = knownVmMacAddr;
                return this.self();
            }

            @Generated
            public B knownDockerMacAddr(boolean knownDockerMacAddr) {
                this.knownDockerMacAddr = knownDockerMacAddr;
                return this.self();
            }

            @Generated
            public String toString() {
                return "HostUsage.Hardware.HardwareBuilder(logicalProcessorCount=" + this.logicalProcessorCount + ", physicalProcessorCount=" + this.physicalProcessorCount + ", maxFreq=" + this.maxFreq + ", memory=" + this.memory + ", knownVmMacAddr=" + this.knownVmMacAddr + ", knownDockerMacAddr=" + this.knownDockerMacAddr + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class HardwareBuilderImpl
        extends HardwareBuilder<Hardware, HardwareBuilderImpl> {
            @Generated
            private HardwareBuilderImpl() {
            }

            @Override
            @Generated
            protected HardwareBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Hardware build() {
                return new Hardware(this);
            }
        }
    }

    @Introspected
    @JsonDeserialize(builder=OsBuilderImpl.class)
    public static class Os {
        private final String family;
        private final String version;
        private final String codeName;
        private final String buildNumber;

        @Generated
        protected Os(OsBuilder<?, ?> b) {
            this.family = b.family;
            this.version = b.version;
            this.codeName = b.codeName;
            this.buildNumber = b.buildNumber;
        }

        @Generated
        public static OsBuilder<?, ?> builder() {
            return new OsBuilderImpl();
        }

        @Generated
        public String getFamily() {
            return this.family;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getCodeName() {
            return this.codeName;
        }

        @Generated
        public String getBuildNumber() {
            return this.buildNumber;
        }

        @Generated
        public static abstract class OsBuilder<C extends Os, B extends OsBuilder<C, B>> {
            @Generated
            private String family;
            @Generated
            private String version;
            @Generated
            private String codeName;
            @Generated
            private String buildNumber;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B family(String family) {
                this.family = family;
                return this.self();
            }

            @Generated
            public B version(String version) {
                this.version = version;
                return this.self();
            }

            @Generated
            public B codeName(String codeName) {
                this.codeName = codeName;
                return this.self();
            }

            @Generated
            public B buildNumber(String buildNumber) {
                this.buildNumber = buildNumber;
                return this.self();
            }

            @Generated
            public String toString() {
                return "HostUsage.Os.OsBuilder(family=" + this.family + ", version=" + this.version + ", codeName=" + this.codeName + ", buildNumber=" + this.buildNumber + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class OsBuilderImpl
        extends OsBuilder<Os, OsBuilderImpl> {
            @Generated
            private OsBuilderImpl() {
            }

            @Override
            @Generated
            protected OsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Os build() {
                return new Os(this);
            }
        }
    }

    @Introspected
    @JsonDeserialize(builder=JvmBuilderImpl.class)
    public static class Jvm {
        private final String name;
        private final String vendor;
        private final String version;

        @Generated
        protected Jvm(JvmBuilder<?, ?> b) {
            this.name = b.name;
            this.vendor = b.vendor;
            this.version = b.version;
        }

        @Generated
        public static JvmBuilder<?, ?> builder() {
            return new JvmBuilderImpl();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVendor() {
            return this.vendor;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public static abstract class JvmBuilder<C extends Jvm, B extends JvmBuilder<C, B>> {
            @Generated
            private String name;
            @Generated
            private String vendor;
            @Generated
            private String version;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B name(String name) {
                this.name = name;
                return this.self();
            }

            @Generated
            public B vendor(String vendor) {
                this.vendor = vendor;
                return this.self();
            }

            @Generated
            public B version(String version) {
                this.version = version;
                return this.self();
            }

            @Generated
            public String toString() {
                return "HostUsage.Jvm.JvmBuilder(name=" + this.name + ", vendor=" + this.vendor + ", version=" + this.version + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class JvmBuilderImpl
        extends JvmBuilder<Jvm, JvmBuilderImpl> {
            @Generated
            private JvmBuilderImpl() {
            }

            @Override
            @Generated
            protected JvmBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Jvm build() {
                return new Jvm(this);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class HostUsageBuilderImpl
    extends HostUsageBuilder<HostUsage, HostUsageBuilderImpl> {
        @Generated
        private HostUsageBuilderImpl() {
        }

        @Override
        @Generated
        protected HostUsageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HostUsage build() {
            return new HostUsage(this);
        }
    }
}

