/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.kestra.core.contexts.KestraApplicationContext;
import io.kestra.core.plugins.PluginRegistry;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Introspected;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@Introspected
@JsonDeserialize(builder=PluginUsageBuilderImpl.class)
public class PluginUsage {
    private final Map<String, String> manifest;

    public static List<PluginUsage> of(ApplicationContext applicationContext) {
        if (!(applicationContext instanceof KestraApplicationContext)) {
            throw new RuntimeException("Invalid ApplicationContext");
        }
        KestraApplicationContext context = (KestraApplicationContext)applicationContext;
        PluginRegistry pluginRegistry = context.getPluginRegistry();
        if (pluginRegistry == null) {
            return List.of();
        }
        return pluginRegistry.getPlugins().stream().map(registeredPlugin -> ((PluginUsageBuilder)PluginUsage.builder().manifest(registeredPlugin.getManifest().getMainAttributes().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>(e.getKey().toString(), e.getValue().toString())).filter(e -> ((String)e.getKey()).startsWith("X-Kestra")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).build()).collect(Collectors.toList());
    }

    @Generated
    protected PluginUsage(PluginUsageBuilder<?, ?> b) {
        this.manifest = b.manifest;
    }

    @Generated
    public static PluginUsageBuilder<?, ?> builder() {
        return new PluginUsageBuilderImpl();
    }

    @Generated
    public Map<String, String> getManifest() {
        return this.manifest;
    }

    @Generated
    public static abstract class PluginUsageBuilder<C extends PluginUsage, B extends PluginUsageBuilder<C, B>> {
        @Generated
        private Map<String, String> manifest;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B manifest(Map<String, String> manifest) {
            this.manifest = manifest;
            return this.self();
        }

        @Generated
        public String toString() {
            return "PluginUsage.PluginUsageBuilder(manifest=" + this.manifest + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class PluginUsageBuilderImpl
    extends PluginUsageBuilder<PluginUsage, PluginUsageBuilderImpl> {
        @Generated
        private PluginUsageBuilderImpl() {
        }

        @Override
        @Generated
        protected PluginUsageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PluginUsage build() {
            return new PluginUsage(this);
        }
    }
}

