/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.DayOfWeek;
import java.time.LocalDate;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for allows events on weekdays")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.DayWeekCondition", "      dayOfWeek: \"MONDAY\""})})
public class DayWeekCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test", description="Can be any variable or any valid ISO 8601 datetime, default will use `{{ now(format=\"iso_local_date\") }}`")
    @PluginProperty(dynamic=true)
    private final String date;
    @NotNull
    @Schema(title="The day of week")
    @PluginProperty(dynamic=false)
    private DayOfWeek dayOfWeek;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        String render = conditionContext.getRunContext().render(this.date, conditionContext.getVariables());
        LocalDate currentDate = DateUtils.parseLocalDate(render);
        return currentDate.getDayOfWeek().equals(this.dayOfWeek);
    }

    @Generated
    private static String $default$date() {
        return "{{ now(format=\"iso_local_date\") }}";
    }

    @Generated
    protected DayWeekCondition(DayWeekConditionBuilder<?, ?> b) {
        super((Condition.ConditionBuilder)b);
        this.date = b.date$set ? b.date$value : DayWeekCondition.$default$date();
        this.dayOfWeek = b.dayOfWeek;
    }

    @Generated
    public static DayWeekConditionBuilder<?, ?> builder() {
        return new DayWeekConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DayWeekCondition(super=" + super.toString() + ", date=" + this.getDate() + ", dayOfWeek=" + this.getDayOfWeek() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DayWeekCondition)) {
            return false;
        }
        DayWeekCondition other = (DayWeekCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        DayOfWeek this$dayOfWeek = this.getDayOfWeek();
        DayOfWeek other$dayOfWeek = other.getDayOfWeek();
        return !(this$dayOfWeek == null ? other$dayOfWeek != null : !this$dayOfWeek.equals(other$dayOfWeek));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DayWeekCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        DayOfWeek $dayOfWeek = this.getDayOfWeek();
        result = result * 59 + ($dayOfWeek == null ? 43 : $dayOfWeek.hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String getDate() {
        return this.date;
    }

    @NotNull
    @Generated
    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public DayWeekCondition() {
        this.date = DayWeekCondition.$default$date();
    }

    @Generated
    public static abstract class DayWeekConditionBuilder<C extends DayWeekCondition, B extends DayWeekConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private String date$value;
        @Generated
        private DayOfWeek dayOfWeek;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B date(@NotNull String date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B dayOfWeek(@NotNull DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DayWeekCondition.DayWeekConditionBuilder(super=" + super.toString() + ", date$value=" + this.date$value + ", dayOfWeek=" + this.dayOfWeek + ")";
        }
    }

    @Generated
    private static final class DayWeekConditionBuilderImpl
    extends DayWeekConditionBuilder<DayWeekCondition, DayWeekConditionBuilderImpl> {
        @Generated
        private DayWeekConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected DayWeekConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DayWeekCondition build() {
            return new DayWeekCondition(this);
        }
    }
}

