/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.flows.State;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;

@Schema(title="Condition based on execution status")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.ExecutionStatusCondition", "      in:", "        - SUCCESS", "      notIn: ", "        - FAILED"})})
public class ExecutionStatusCondition
extends Condition {
    @Valid
    @Schema(title="List of state that are authorized")
    private List<State.Type> in;
    @Valid
    @Schema(title="List of state that aren't authorized")
    private List<State.Type> notIn;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (conditionContext.getExecution() == null) {
            throw new IllegalConditionEvaluation("Invalid condition with execution null");
        }
        boolean result = true;
        if (this.in != null && !this.in.contains((Object)conditionContext.getExecution().getState().getCurrent())) {
            result = false;
        }
        if (this.notIn != null && this.notIn.contains((Object)conditionContext.getExecution().getState().getCurrent())) {
            result = false;
        }
        return result;
    }

    @Generated
    protected ExecutionStatusCondition(ExecutionStatusConditionBuilder<?, ?> b) {
        super((Condition.ConditionBuilder)b);
        this.in = b.in;
        this.notIn = b.notIn;
    }

    @Generated
    public static ExecutionStatusConditionBuilder<?, ?> builder() {
        return new ExecutionStatusConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionStatusCondition(super=" + super.toString() + ", in=" + this.getIn() + ", notIn=" + this.getNotIn() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionStatusCondition)) {
            return false;
        }
        ExecutionStatusCondition other = (ExecutionStatusCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<State.Type> this$in = this.getIn();
        List<State.Type> other$in = other.getIn();
        if (this$in == null ? other$in != null : !((Object)this$in).equals(other$in)) {
            return false;
        }
        List<State.Type> this$notIn = this.getNotIn();
        List<State.Type> other$notIn = other.getNotIn();
        return !(this$notIn == null ? other$notIn != null : !((Object)this$notIn).equals(other$notIn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionStatusCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<State.Type> $in = this.getIn();
        result = result * 59 + ($in == null ? 43 : ((Object)$in).hashCode());
        List<State.Type> $notIn = this.getNotIn();
        result = result * 59 + ($notIn == null ? 43 : ((Object)$notIn).hashCode());
        return result;
    }

    @Generated
    public List<State.Type> getIn() {
        return this.in;
    }

    @Generated
    public List<State.Type> getNotIn() {
        return this.notIn;
    }

    @Generated
    public ExecutionStatusCondition() {
    }

    @Generated
    public static abstract class ExecutionStatusConditionBuilder<C extends ExecutionStatusCondition, B extends ExecutionStatusConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private List<State.Type> in;
        @Generated
        private List<State.Type> notIn;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B in(List<State.Type> in) {
            this.in = in;
            return (B)this.self();
        }

        @Generated
        public B notIn(List<State.Type> notIn) {
            this.notIn = notIn;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ExecutionStatusCondition.ExecutionStatusConditionBuilder(super=" + super.toString() + ", in=" + this.in + ", notIn=" + this.notIn + ")";
        }
    }

    @Generated
    private static final class ExecutionStatusConditionBuilderImpl
    extends ExecutionStatusConditionBuilder<ExecutionStatusCondition, ExecutionStatusConditionBuilderImpl> {
        @Generated
        private ExecutionStatusConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionStatusConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionStatusCondition build() {
            return new ExecutionStatusCondition(this);
        }
    }
}

