/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition based on variables expression", description="If the result is an empty string, a string containing only space or `false`, the condition will be false")
@Plugin(examples={@Example(title="A condition that will return false for a missing variable", full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.VariableCondition", "      expression: {{ unknown is defined }}"})})
public class VariableCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @NotEmpty
    private String expression;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        String render = conditionContext.getRunContext().render(this.expression, conditionContext.getVariables());
        return !render.isBlank() && !render.isEmpty() && !render.trim().equals("false");
    }

    @Generated
    protected VariableCondition(VariableConditionBuilder<?, ?> b) {
        super(b);
        this.expression = b.expression;
    }

    @Generated
    public static VariableConditionBuilder<?, ?> builder() {
        return new VariableConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "VariableCondition(super=" + super.toString() + ", expression=" + this.getExpression() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableCondition)) {
            return false;
        }
        VariableCondition other = (VariableCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VariableCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public VariableCondition() {
    }

    @Generated
    public static abstract class VariableConditionBuilder<C extends VariableCondition, B extends VariableConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private String expression;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B expression(@NotNull String expression) {
            this.expression = expression;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "VariableCondition.VariableConditionBuilder(super=" + super.toString() + ", expression=" + this.expression + ")";
        }
    }

    @Generated
    private static final class VariableConditionBuilderImpl
    extends VariableConditionBuilder<VariableCondition, VariableConditionBuilderImpl> {
        @Generated
        private VariableConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected VariableConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VariableCondition build() {
            return new VariableCondition(this);
        }
    }
}

