/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.tasks.Task;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public final class ResolvedTask {
    @NotNull
    private final Task task;
    private final String value;
    private final String parentId;

    public NextTaskRun toNextTaskRun(Execution execution) {
        return new NextTaskRun(TaskRun.of(execution, this), this.getTask());
    }

    public static ResolvedTask of(Task task) {
        return ResolvedTask.builder().task(task).build();
    }

    public static List<ResolvedTask> of(List<Task> tasks) {
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(ResolvedTask::of).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"task", "value", "parentId"})
    @Generated
    ResolvedTask(@NotNull Task task, String value, String parentId) {
        this.task = task;
        this.value = value;
        this.parentId = parentId;
    }

    @Generated
    public static ResolvedTaskBuilder builder() {
        return new ResolvedTaskBuilder();
    }

    @NotNull
    @Generated
    public Task getTask() {
        return this.task;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedTask)) {
            return false;
        }
        ResolvedTask other = (ResolvedTask)o;
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        return !(this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResolvedTask(task=" + this.getTask() + ", value=" + this.getValue() + ", parentId=" + this.getParentId() + ")";
    }

    @Generated
    public static class ResolvedTaskBuilder {
        @Generated
        private Task task;
        @Generated
        private String value;
        @Generated
        private String parentId;

        @Generated
        ResolvedTaskBuilder() {
        }

        @Generated
        public ResolvedTaskBuilder task(@NotNull Task task) {
            this.task = task;
            return this;
        }

        @Generated
        public ResolvedTaskBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public ResolvedTaskBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        @Generated
        public ResolvedTask build() {
            return new ResolvedTask(this.task, this.value, this.parentId);
        }

        @Generated
        public String toString() {
            return "ResolvedTask.ResolvedTaskBuilder(task=" + this.task + ", value=" + this.value + ", parentId=" + this.parentId + ")";
        }
    }
}

