/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.types;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.validations.CronExpression;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@io.kestra.core.validations.Schedule
@Schema(title="Schedule a flow based on cron date", description="Kestra is able to trigger flow based on Schedule (aka the time). If you need to wait another system to be ready and can't use any event mechanism, you can schedule 1 or more time for the current flow.\n\nThe scheduler will keep the last execution date for this schedule based on the id. This allow you to change the cron expression without restart all the past execution (if backfill exists)\nIf you changed the current id, the scheduler will think it's a new schedule and will start with a fresh date and replay the all backfill date (if backfill exists)")
@Plugin(examples={@Example(title="A schedule with a backfill", code={"triggers:", "  - id: schedule", "    type: io.kestra.core.models.triggers.types.Schedule", "    cron: \"*/15 * * * *\"", "    backfill:", "      start: 2020-06-25T14:00:00Z"}, full=true), @Example(title="A schedule with a nickname", code={"triggers:", "  - id: schedule", "    type: io.kestra.core.models.triggers.types.Schedule", "    cron: \"@hourly\""}, full=true), @Example(title="A schedule that run only the first monday on every month at 11 AM", code={"triggers:", "  - id: schedule", "    cron: \"0 11 * * 1\"", "    scheduleConditions:", "      - id: monday", "        date: \"{{ trigger.date }}\"", "        dayOfWeek: \"MONDAY\"", "        dayInMonth: \"FIRST\""}, full=true)})
public class Schedule
extends AbstractTrigger
implements PollingTriggerInterface,
TriggerOutput<Output> {
    public static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.defineCron().withMinutes().withValidRange(0, 59).withStrictRange().and().withHours().withValidRange(0, 23).withStrictRange().and().withDayOfMonth().withValidRange(1, 31).withStrictRange().and().withMonth().withValidRange(1, 12).withStrictRange().and().withDayOfWeek().withValidRange(0, 7).withMondayDoWValue(1).withIntMapping(7, 0).withStrictRange().and().withSupportedNicknameYearly().withSupportedNicknameAnnually().withSupportedNicknameMonthly().withSupportedNicknameWeekly().withSupportedNicknameDaily().withSupportedNicknameMidnight().withSupportedNicknameHourly().instance());
    @NotNull
    @CronExpression
    @Schema(title="the cron expression", description="a standard [unix cron expression](https://en.wikipedia.org/wiki/Cron) without second.\nCan also be a cron extensions / nicknames:\n* `@yearly`\n* `@annually`\n* `@monthly`\n* `@weekly`\n* `@daily`\n* `@midnight`\n* `@hourly`")
    private String cron;
    @Schema(title="The time zone id to use for evaluate cron. Default value is the server default zone id.")
    @PluginProperty(dynamic=false)
    private String timezone;
    @Schema(title="Backfill options in order to fill missing previous past date", description="Kestra will handle optionally a backfill. The concept of backfill is the replay the missing schedule because we create the flow later.\n\nBackfill will do all schedules between define date & current date and will start after the normal schedule.")
    private ScheduleBackfill backfill;
    private final Duration interval;
    @Valid
    @Schema(title="List of schedule Conditions in order to limit schedule date.")
    private List<ScheduleCondition> scheduleConditions;
    @Schema(title="The input to pass to the triggered flow")
    @PluginProperty(dynamic=true)
    private Map<String, String> inputs;
    @Schema(title="The maximum late delay accepted", description="If the schedule didn't start after this delay, the execution will be skip.")
    private Duration lateMaximumDelay;
    private transient ExecutionTime executionTime;

    @Override
    public ZonedDateTime nextEvaluationDate(ConditionContext conditionContext, Optional<? extends TriggerContext> last) {
        ExecutionTime executionTime = this.executionTime();
        if (last.isPresent()) {
            Optional<ZonedDateTime> next;
            ZonedDateTime lastDate = this.convertDateTime(last.get().getDate());
            if (this.scheduleConditions != null && (next = this.truePreviousNextDateWithCondition(executionTime, conditionContext, lastDate, true)).isPresent()) {
                return next.get().truncatedTo(ChronoUnit.SECONDS);
            }
            return this.computeNextEvaluationDate(executionTime, lastDate).orElse(null);
        }
        if (this.backfill != null && this.backfill.getStart() != null) {
            return this.timezone != null ? this.backfill.getStart().withZoneSameLocal(ZoneId.of(this.timezone)) : this.backfill.getStart();
        }
        return this.computeNextEvaluationDate(executionTime, ZonedDateTime.now()).orElse(null);
    }

    @Override
    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        boolean isLate;
        RunContext runContext = conditionContext.getRunContext();
        ExecutionTime executionTime = this.executionTime();
        ZonedDateTime previousDate = this.convertDateTime(context.getDate());
        Output output = this.output(executionTime, previousDate).orElse(null);
        if ((output = this.handleMaxDelay(output)) == null || output.getDate() == null) {
            return Optional.empty();
        }
        ZonedDateTime next = output.getDate();
        boolean isReady = next.compareTo(previousDate) == 0;
        boolean bl = isLate = next.compareTo(ZonedDateTime.now().minus(Duration.ofMinutes(1L))) < 0;
        if (!isReady && !isLate) {
            return Optional.empty();
        }
        if (next.compareTo(ZonedDateTime.now().plus(Duration.ofSeconds(1L))) > 0) {
            return Optional.empty();
        }
        conditionContext = this.conditionContext(conditionContext, output);
        if (this.scheduleConditions != null) {
            boolean conditionResults = this.validateScheduleCondition(conditionContext);
            if (!conditionResults) {
                return Optional.empty();
            }
            output = this.trueOutputWithCondition(executionTime, conditionContext, output);
        }
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (this.inputs != null) {
            for (Map.Entry<String, String> entry : this.inputs.entrySet()) {
                inputs.put(entry.getKey(), runContext.render(entry.getValue()));
            }
        }
        Map<String, Object> variables = this.timezone != null ? output.toMap(ZoneId.of(this.timezone)) : output.toMap();
        ExecutionTrigger executionTrigger = ExecutionTrigger.of((AbstractTrigger)this, variables);
        Execution execution = Execution.builder().id(IdUtils.create()).namespace(context.getNamespace()).flowId(context.getFlowId()).flowRevision(context.getFlowRevision()).state(new State()).trigger(executionTrigger).inputs(inputs).variables((Map<String, Object>)ImmutableMap.of((Object)"schedule", executionTrigger.getVariables())).build();
        return Optional.of(execution);
    }

    private Optional<Output> output(ExecutionTime executionTime, ZonedDateTime date) {
        Optional next = executionTime.nextExecution(date.minus(Duration.ofSeconds(1L)));
        if (next.isEmpty()) {
            return Optional.empty();
        }
        Object outputBuilder = Output.builder().date(this.convertDateTime((ZonedDateTime)next.get()));
        this.computeNextEvaluationDate(executionTime, (ZonedDateTime)next.get()).map(this::convertDateTime).ifPresent(arg_0 -> outputBuilder.next(arg_0));
        executionTime.lastExecution(date).map(this::convertDateTime).ifPresent(arg_0 -> outputBuilder.previous(arg_0));
        Object output = ((Output.OutputBuilder)outputBuilder).build();
        return Optional.of(output);
    }

    private ConditionContext conditionContext(ConditionContext conditionContext, Output output) {
        return conditionContext.withVariables((Map<String, Object>)ImmutableMap.of((Object)"schedule", output.toMap(), (Object)"trigger", output.toMap()));
    }

    private synchronized ExecutionTime executionTime() {
        if (this.executionTime == null) {
            Cron parse = CRON_PARSER.parse(this.cron);
            this.executionTime = ExecutionTime.forCron((Cron)parse);
        }
        return this.executionTime;
    }

    private ZonedDateTime convertDateTime(ZonedDateTime date) {
        if (this.timezone == null) {
            return date;
        }
        return date.withZoneSameInstant(ZoneId.of(this.timezone));
    }

    private Optional<ZonedDateTime> computeNextEvaluationDate(ExecutionTime executionTime, ZonedDateTime date) {
        return executionTime.nextExecution(date).map(zonedDateTime -> zonedDateTime.truncatedTo(ChronoUnit.SECONDS));
    }

    private Output trueOutputWithCondition(ExecutionTime executionTime, ConditionContext conditionContext, Output output) {
        Object outputBuilder = Output.builder().date(output.getDate());
        this.truePreviousNextDateWithCondition(executionTime, conditionContext, output.getDate(), true).ifPresent(arg_0 -> outputBuilder.next(arg_0));
        this.truePreviousNextDateWithCondition(executionTime, conditionContext, output.getDate(), false).ifPresent(arg_0 -> outputBuilder.previous(arg_0));
        return ((Output.OutputBuilder)outputBuilder).build();
    }

    private Optional<ZonedDateTime> truePreviousNextDateWithCondition(ExecutionTime executionTime, ConditionContext conditionContext, ZonedDateTime toTestDate, boolean next) {
        while (next && toTestDate.getYear() < ZonedDateTime.now().getYear() + 10 || !next && toTestDate.getYear() > ZonedDateTime.now().getYear() - 10) {
            Optional currentDate;
            Optional optional = currentDate = next ? executionTime.nextExecution(toTestDate) : executionTime.lastExecution(toTestDate);
            if (currentDate.isEmpty()) {
                return currentDate;
            }
            Optional<Output> currentOutput = this.output(executionTime, (ZonedDateTime)currentDate.get());
            if (currentOutput.isEmpty()) {
                return Optional.empty();
            }
            ConditionContext currentConditionContext = this.conditionContext(conditionContext, currentOutput.get());
            boolean conditionResults = this.validateScheduleCondition(currentConditionContext);
            if (conditionResults) {
                return currentDate;
            }
            toTestDate = (ZonedDateTime)currentDate.get();
        }
        return Optional.empty();
    }

    private Output handleMaxDelay(Output output) {
        if (output == null) {
            return null;
        }
        if (this.lateMaximumDelay == null) {
            return output;
        }
        while (output.getDate().getYear() < ZonedDateTime.now().getYear() + 10 || output.getDate().getYear() > ZonedDateTime.now().getYear() - 10) {
            if (output.getDate().plus(this.lateMaximumDelay).compareTo(ZonedDateTime.now()) < 0) {
                if ((output = (Output)this.output(this.executionTime, output.getNext()).orElse(null)) != null) continue;
                return null;
            }
            return output;
        }
        return output;
    }

    private boolean validateScheduleCondition(ConditionContext conditionContext) {
        if (this.scheduleConditions != null) {
            ConditionService conditionService = (ConditionService)conditionContext.getRunContext().getApplicationContext().getBean(ConditionService.class);
            return conditionService.isValid(conditionContext.getFlow(), this.scheduleConditions, conditionContext);
        }
        return true;
    }

    @Generated
    private static String $default$timezone() {
        return ZoneId.systemDefault().toString();
    }

    @Generated
    private static Duration $default$interval() {
        return null;
    }

    @Generated
    protected Schedule(ScheduleBuilder<?, ?> b) {
        super(b);
        this.cron = b.cron;
        this.timezone = b.timezone$set ? b.timezone$value : Schedule.$default$timezone();
        this.backfill = b.backfill;
        this.interval = b.interval$set ? b.interval$value : Schedule.$default$interval();
        this.scheduleConditions = b.scheduleConditions;
        this.inputs = b.inputs;
        this.lateMaximumDelay = b.lateMaximumDelay;
        this.executionTime = b.executionTime;
    }

    @Generated
    public static ScheduleBuilder<?, ?> builder() {
        return new ScheduleBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Schedule(super=" + super.toString() + ", cron=" + this.getCron() + ", timezone=" + this.getTimezone() + ", backfill=" + this.getBackfill() + ", interval=" + this.getInterval() + ", scheduleConditions=" + this.getScheduleConditions() + ", inputs=" + this.getInputs() + ", lateMaximumDelay=" + this.getLateMaximumDelay() + ", executionTime=" + this.executionTime + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        ScheduleBackfill this$backfill = this.getBackfill();
        ScheduleBackfill other$backfill = other.getBackfill();
        if (this$backfill == null ? other$backfill != null : !((Object)this$backfill).equals(other$backfill)) {
            return false;
        }
        Duration this$interval = this.getInterval();
        Duration other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        List<ScheduleCondition> this$scheduleConditions = this.getScheduleConditions();
        List<ScheduleCondition> other$scheduleConditions = other.getScheduleConditions();
        if (this$scheduleConditions == null ? other$scheduleConditions != null : !((Object)this$scheduleConditions).equals(other$scheduleConditions)) {
            return false;
        }
        Map<String, String> this$inputs = this.getInputs();
        Map<String, String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Duration this$lateMaximumDelay = this.getLateMaximumDelay();
        Duration other$lateMaximumDelay = other.getLateMaximumDelay();
        return !(this$lateMaximumDelay == null ? other$lateMaximumDelay != null : !((Object)this$lateMaximumDelay).equals(other$lateMaximumDelay));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Schedule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        ScheduleBackfill $backfill = this.getBackfill();
        result = result * 59 + ($backfill == null ? 43 : ((Object)$backfill).hashCode());
        Duration $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        List<ScheduleCondition> $scheduleConditions = this.getScheduleConditions();
        result = result * 59 + ($scheduleConditions == null ? 43 : ((Object)$scheduleConditions).hashCode());
        Map<String, String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Duration $lateMaximumDelay = this.getLateMaximumDelay();
        result = result * 59 + ($lateMaximumDelay == null ? 43 : ((Object)$lateMaximumDelay).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String getCron() {
        return this.cron;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public ScheduleBackfill getBackfill() {
        return this.backfill;
    }

    @Override
    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Generated
    public List<ScheduleCondition> getScheduleConditions() {
        return this.scheduleConditions;
    }

    @Generated
    public Map<String, String> getInputs() {
        return this.inputs;
    }

    @Generated
    public Duration getLateMaximumDelay() {
        return this.lateMaximumDelay;
    }

    @Generated
    public Schedule() {
        this.timezone = Schedule.$default$timezone();
        this.interval = Schedule.$default$interval();
    }

    public static final class ScheduleBackfill {
        @Schema(title="The first start date")
        private final ZonedDateTime start;

        @ConstructorProperties(value={"start"})
        @Generated
        ScheduleBackfill(ZonedDateTime start) {
            this.start = start;
        }

        @Generated
        public static ScheduleBackfillBuilder builder() {
            return new ScheduleBackfillBuilder();
        }

        @Generated
        public ZonedDateTime getStart() {
            return this.start;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScheduleBackfill)) {
                return false;
            }
            ScheduleBackfill other = (ScheduleBackfill)o;
            ZonedDateTime this$start = this.getStart();
            ZonedDateTime other$start = other.getStart();
            return !(this$start == null ? other$start != null : !((Object)this$start).equals(other$start));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ZonedDateTime $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Schedule.ScheduleBackfill(start=" + this.getStart() + ")";
        }

        @Generated
        public static class ScheduleBackfillBuilder {
            @Generated
            private ZonedDateTime start;

            @Generated
            ScheduleBackfillBuilder() {
            }

            @Generated
            public ScheduleBackfillBuilder start(ZonedDateTime start) {
                this.start = start;
                return this;
            }

            @Generated
            public ScheduleBackfill build() {
                return new ScheduleBackfill(this.start);
            }

            @Generated
            public String toString() {
                return "Schedule.ScheduleBackfill.ScheduleBackfillBuilder(start=" + this.start + ")";
            }
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The date of current schedule ")
        @NotNull
        private ZonedDateTime date;
        @Schema(title="The date of next schedule ")
        @NotNull
        private ZonedDateTime next;
        @Schema(title="The date of previous schedule ")
        @NotNull
        private ZonedDateTime previous;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.date = b.date;
            this.next = b.next;
            this.previous = b.previous;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public String toString() {
            return "Schedule.Output(date=" + this.getDate() + ", next=" + this.getNext() + ", previous=" + this.getPrevious() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ZonedDateTime this$date = this.getDate();
            ZonedDateTime other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            ZonedDateTime this$next = this.getNext();
            ZonedDateTime other$next = other.getNext();
            if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
                return false;
            }
            ZonedDateTime this$previous = this.getPrevious();
            ZonedDateTime other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ZonedDateTime $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            ZonedDateTime $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
            ZonedDateTime $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public ZonedDateTime getDate() {
            return this.date;
        }

        @NotNull
        @Generated
        public ZonedDateTime getNext() {
            return this.next;
        }

        @NotNull
        @Generated
        public ZonedDateTime getPrevious() {
            return this.previous;
        }

        @Generated
        public Output() {
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private ZonedDateTime date;
            @Generated
            private ZonedDateTime next;
            @Generated
            private ZonedDateTime previous;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B date(@NotNull ZonedDateTime date) {
                this.date = date;
                return this.self();
            }

            @Generated
            public B next(@NotNull ZonedDateTime next) {
                this.next = next;
                return this.self();
            }

            @Generated
            public B previous(@NotNull ZonedDateTime previous) {
                this.previous = previous;
                return this.self();
            }

            @Generated
            public String toString() {
                return "Schedule.Output.OutputBuilder(date=" + this.date + ", next=" + this.next + ", previous=" + this.previous + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }

    @Generated
    public static abstract class ScheduleBuilder<C extends Schedule, B extends ScheduleBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private String cron;
        @Generated
        private boolean timezone$set;
        @Generated
        private String timezone$value;
        @Generated
        private ScheduleBackfill backfill;
        @Generated
        private boolean interval$set;
        @Generated
        private Duration interval$value;
        @Generated
        private List<ScheduleCondition> scheduleConditions;
        @Generated
        private Map<String, String> inputs;
        @Generated
        private Duration lateMaximumDelay;
        @Generated
        private ExecutionTime executionTime;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B cron(@NotNull String cron) {
            this.cron = cron;
            return (B)this.self();
        }

        @Generated
        public B timezone(String timezone) {
            this.timezone$value = timezone;
            this.timezone$set = true;
            return (B)this.self();
        }

        @Generated
        public B backfill(ScheduleBackfill backfill) {
            this.backfill = backfill;
            return (B)this.self();
        }

        @Generated
        public B interval(Duration interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return (B)this.self();
        }

        @Generated
        public B scheduleConditions(List<ScheduleCondition> scheduleConditions) {
            this.scheduleConditions = scheduleConditions;
            return (B)this.self();
        }

        @Generated
        public B inputs(Map<String, String> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B lateMaximumDelay(Duration lateMaximumDelay) {
            this.lateMaximumDelay = lateMaximumDelay;
            return (B)this.self();
        }

        @Generated
        public B executionTime(ExecutionTime executionTime) {
            this.executionTime = executionTime;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Schedule.ScheduleBuilder(super=" + super.toString() + ", cron=" + this.cron + ", timezone$value=" + this.timezone$value + ", backfill=" + this.backfill + ", interval$value=" + this.interval$value + ", scheduleConditions=" + this.scheduleConditions + ", inputs=" + this.inputs + ", lateMaximumDelay=" + this.lateMaximumDelay + ", executionTime=" + this.executionTime + ")";
        }
    }

    @Generated
    private static final class ScheduleBuilderImpl
    extends ScheduleBuilder<Schedule, ScheduleBuilderImpl> {
        @Generated
        private ScheduleBuilderImpl() {
        }

        @Override
        @Generated
        protected ScheduleBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Schedule build() {
            return new Schedule(this);
        }
    }
}

