/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    private static Pattern DEFAULT_PACKAGES_TO_IGNORE;
    private final ClassLoader parent;
    private final URL pluginLocation;
    private final ClassLoader systemClassLoader;

    public static PluginClassLoader of(URL pluginLocation, URL[] urls, ClassLoader parent) {
        return AccessController.doPrivileged(() -> new PluginClassLoader(pluginLocation, urls, parent));
    }

    private PluginClassLoader(URL pluginLocation, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
        this.pluginLocation = pluginLocation;
        this.systemClassLoader = PluginClassLoader.getSystemClassLoader();
    }

    public String location() {
        return this.pluginLocation.toString();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                loadedClass = this.mayLoadFromSystemClassLoader(name);
            }
            if (loadedClass == null && PluginClassLoader.shouldLoadFromUrls(name)) {
                try {
                    loadedClass = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    log.debug("Class '{}' not found on '{}' for plugin '{}', delegating to parent '{}'", new Object[]{name, this.getName(), this.pluginLocation, this.parent.getName()});
                }
            }
            if (loadedClass == null) {
                loadedClass = super.loadClass(name, resolve);
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    private static boolean shouldLoadFromUrls(String name) {
        return !DEFAULT_PACKAGES_TO_IGNORE.matcher(name).matches();
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        Enumeration[] e = new Enumeration[3];
        e[1] = this.findResources(name);
        return new CompoundEnumeration<URL>(e);
    }

    private Enumeration<URL> getResourcesFromSystem(String name) throws IOException {
        if (this.systemClassLoader != null) {
            return this.systemClassLoader.getResources(name);
        }
        return Collections.emptyEnumeration();
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL res = null;
        if (res == null) {
            res = this.findResource(name);
        }
        return res;
    }

    private Class<?> mayLoadFromSystemClassLoader(String name) {
        Class<?> loadedClass = null;
        try {
            if (this.systemClassLoader != null) {
                loadedClass = this.systemClassLoader.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return loadedClass;
    }

    public String toString() {
        return "PluginClassLoader[location=" + this.pluginLocation + "] ";
    }

    static {
        ClassLoader.registerAsParallelCapable();
        DEFAULT_PACKAGES_TO_IGNORE = Pattern.compile("(?:|io.kestra.core|org.slf4j)\\..*$");
    }

    static final class CompoundEnumeration<E>
    implements Enumeration<E> {
        private final Enumeration<E>[] enums;
        private int index;

        CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

