/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import com.google.common.collect.ImmutableList;
import io.kestra.core.plugins.RegisteredPlugin;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Singleton
public class PluginRegistry {
    private List<RegisteredPlugin> plugins;
    private Map<String, RegisteredPlugin> pluginsByClass;

    public PluginRegistry(List<RegisteredPlugin> registeredPlugin) {
        this.plugins = ImmutableList.copyOf(registeredPlugin);
        this.pluginsByClass = registeredPlugin.stream().flatMap(plugin -> Stream.of(plugin.getTasks().stream().map(r -> new AbstractMap.SimpleEntry<String, RegisteredPlugin>(r.getName(), (RegisteredPlugin)plugin)), plugin.getTriggers().stream().map(r -> new AbstractMap.SimpleEntry<String, RegisteredPlugin>(r.getName(), (RegisteredPlugin)plugin)), plugin.getConditions().stream().map(r -> new AbstractMap.SimpleEntry<String, RegisteredPlugin>(r.getName(), (RegisteredPlugin)plugin)), plugin.getControllers().stream().map(r -> new AbstractMap.SimpleEntry<String, RegisteredPlugin>(r.getName(), (RegisteredPlugin)plugin))).flatMap(i -> i)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
    }

    public Optional<RegisteredPlugin> find(String name) {
        if (this.pluginsByClass.containsKey(name)) {
            return Optional.of(this.pluginsByClass.get(name));
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"plugins", "pluginsByClass"})
    @Generated
    public PluginRegistry(List<RegisteredPlugin> plugins, Map<String, RegisteredPlugin> pluginsByClass) {
        this.plugins = plugins;
        this.pluginsByClass = pluginsByClass;
    }

    @Generated
    public List<RegisteredPlugin> getPlugins() {
        return this.plugins;
    }

    @Generated
    public Map<String, RegisteredPlugin> getPluginsByClass() {
        return this.pluginsByClass;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginRegistry)) {
            return false;
        }
        PluginRegistry other = (PluginRegistry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RegisteredPlugin> this$plugins = this.getPlugins();
        List<RegisteredPlugin> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        Map<String, RegisteredPlugin> this$pluginsByClass = this.getPluginsByClass();
        Map<String, RegisteredPlugin> other$pluginsByClass = other.getPluginsByClass();
        return !(this$pluginsByClass == null ? other$pluginsByClass != null : !((Object)this$pluginsByClass).equals(other$pluginsByClass));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginRegistry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RegisteredPlugin> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        Map<String, RegisteredPlugin> $pluginsByClass = this.getPluginsByClass();
        result = result * 59 + ($pluginsByClass == null ? 43 : ((Object)$pluginsByClass).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PluginRegistry(plugins=" + this.getPlugins() + ", pluginsByClass=" + this.getPluginsByClass() + ")";
    }
}

