/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.models.SearchResult;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.repositories.ArrayListTotal;
import io.micronaut.data.model.Pageable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;

public interface FlowRepositoryInterface {
    public Optional<Flow> findById(String var1, String var2, Optional<Integer> var3);

    default public Flow findByExecution(Execution execution) {
        Optional<Flow> find = this.findById(execution.getNamespace(), execution.getFlowId(), Optional.of(execution.getFlowRevision()));
        if (find.isEmpty()) {
            throw new IllegalStateException("Unable to find flow '" + execution.getNamespace() + "." + execution.getFlowId() + "' with revision " + execution.getFlowRevision() + " on execution " + execution.getId());
        }
        return find.get();
    }

    default public Optional<Flow> findById(String namespace, String id) {
        return this.findById(namespace, id, Optional.empty());
    }

    public List<Flow> findRevisions(String var1, String var2);

    public List<Flow> findAll();

    public List<Flow> findAllWithRevisions();

    public List<Flow> findByNamespace(String var1);

    public ArrayListTotal<Flow> find(Pageable var1, @Nullable String var2, @Nullable String var3, @Nullable Map<String, String> var4);

    public ArrayListTotal<SearchResult<Flow>> findSourceCode(Pageable var1, @Nullable String var2, @Nullable String var3);

    public List<String> findDistinctNamespace();

    public Flow create(Flow var1) throws ConstraintViolationException;

    public Flow update(Flow var1, Flow var2) throws ConstraintViolationException;

    public Flow delete(Flow var1);
}

