/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.Slugify;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class RunContext {
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    private ApplicationContext applicationContext;
    private VariableRenderer variableRenderer;
    private StorageInterface storageInterface;
    private String envPrefix;
    private MetricRegistry meterRegistry;
    private Path tempBasedPath;
    private URI storageOutputPrefix;
    private URI storageExecutionPrefix;
    private Map<String, Object> variables;
    private List<AbstractMetricEntry<?>> metrics = new ArrayList();
    private RunContextLogger runContextLogger;
    private final List<WorkerTaskResult> dynamicWorkerTaskResult = new ArrayList<WorkerTaskResult>();
    protected transient Path temporaryDirectory;

    public RunContext(ApplicationContext applicationContext, Flow flow, Execution execution) {
        this.initBean(applicationContext);
        this.initContext(flow, null, execution, null);
        this.initLogger(execution);
    }

    public RunContext(ApplicationContext applicationContext, Flow flow, Task task, Execution execution, TaskRun taskRun) {
        this.initBean(applicationContext);
        this.initContext(flow, task, execution, taskRun);
        this.initLogger(taskRun);
    }

    public RunContext(ApplicationContext applicationContext, Flow flow, AbstractTrigger trigger) {
        this.initBean(applicationContext);
        this.storageOutputPrefix = this.storageInterface.outputPrefix(flow);
        this.variables = this.variables(flow, null, null, null, trigger);
        this.initLogger(flow, trigger);
    }

    @VisibleForTesting
    public RunContext(ApplicationContext applicationContext, Map<String, Object> variables) {
        this.initBean(applicationContext);
        this.variables = new HashMap<String, Object>();
        this.variables.putAll(this.variables(null, null, null, null, null));
        this.variables.putAll(variables);
        this.storageOutputPrefix = URI.create("");
        this.runContextLogger = new RunContextLogger();
    }

    protected void initBean(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.variableRenderer = (VariableRenderer)applicationContext.findBean(VariableRenderer.class).orElseThrow();
        this.storageInterface = applicationContext.findBean(StorageInterface.class).orElse(null);
        this.envPrefix = (String)applicationContext.getProperty("kestra.variables.env-vars-prefix", String.class, (Object)"KESTRA_");
        this.meterRegistry = (MetricRegistry)applicationContext.findBean(MetricRegistry.class).orElseThrow();
        this.tempBasedPath = Path.of(applicationContext.getProperty("kestra.tasks.tmp-dir.path", String.class).orElse(System.getProperty("java.io.tmpdir")), new String[0]);
    }

    private void initContext(Flow flow, Task task, Execution execution, TaskRun taskRun) {
        this.variables = this.variables(flow, task, execution, taskRun, null);
        if (taskRun != null && this.storageInterface != null) {
            this.storageOutputPrefix = this.storageInterface.outputPrefix(flow, task, execution, taskRun);
        }
    }

    private void initLogger(TaskRun taskRun) {
        this.runContextLogger = new RunContextLogger((QueueInterface)this.applicationContext.findBean(QueueInterface.class, Qualifiers.byName((String)"workerTaskLogQueue")).orElseThrow(), LogEntry.of(taskRun));
    }

    private void initLogger(Execution execution) {
        this.runContextLogger = new RunContextLogger((QueueInterface)this.applicationContext.findBean(QueueInterface.class, Qualifiers.byName((String)"workerTaskLogQueue")).orElseThrow(), LogEntry.of(execution));
    }

    private void initLogger(Flow flow, AbstractTrigger trigger) {
        this.runContextLogger = new RunContextLogger((QueueInterface)this.applicationContext.findBean(QueueInterface.class, Qualifiers.byName((String)"workerTaskLogQueue")).orElseThrow(), LogEntry.of(flow, trigger));
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public URI getStorageOutputPrefix() {
        return this.storageOutputPrefix;
    }

    @JsonIgnore
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected Map<String, Object> variables(Flow flow, Task task, Execution execution, TaskRun taskRun, AbstractTrigger trigger) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"envs", this.envVariables());
        if (this.applicationContext.getProperty("kestra.variables.globals", Map.class).isPresent()) {
            builder.put((Object)"globals", this.applicationContext.getProperty("kestra.variables.globals", Map.class).get());
        } else {
            builder.put((Object)"globals", Map.of());
        }
        if (flow != null && flow.getVariables() != null) {
            builder.put((Object)"vars", flow.getVariables());
        }
        if (task != null) {
            builder.put((Object)"task", this.variables(task));
        }
        if (taskRun != null) {
            builder.put((Object)"taskrun", this.variables(taskRun));
        }
        if (taskRun != null && execution != null) {
            List<Map<String, Object>> parents = execution.parents(taskRun);
            builder.put((Object)"parents", parents);
            if (parents.size() > 0) {
                builder.put((Object)"parent", parents.get(0));
            }
        }
        if (flow != null) {
            builder.put((Object)"flow", (Object)ImmutableMap.of((Object)"id", (Object)flow.getId(), (Object)"namespace", (Object)flow.getNamespace(), (Object)"revision", (Object)flow.getRevision()));
        }
        if (execution != null) {
            builder.put((Object)"execution", (Object)ImmutableMap.of((Object)"id", (Object)execution.getId(), (Object)"startDate", (Object)execution.getState().getStartDate()));
            if (execution.getTaskRunList() != null) {
                builder.put((Object)"outputs", execution.outputs());
            }
            if (execution.getInputs() != null) {
                builder.put((Object)"inputs", execution.getInputs());
            }
            if (execution.getTrigger() != null && execution.getTrigger().getVariables() != null) {
                builder.put((Object)"trigger", execution.getTrigger().getVariables());
            }
            if (execution.getVariables() != null) {
                builder.putAll(execution.getVariables());
            }
        }
        if (trigger != null) {
            builder.put((Object)"trigger", (Object)ImmutableMap.of((Object)"id", (Object)trigger.getId(), (Object)"type", (Object)trigger.getType()));
        }
        return builder.build();
    }

    private Map<String, String> envVariables() {
        HashMap<String, String> result = new HashMap<String, String>(System.getenv());
        result.putAll(System.getProperties());
        return result.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.envPrefix)).map(e -> new AbstractMap.SimpleEntry<String, String>(((String)e.getKey()).substring(this.envPrefix.length()).toLowerCase(), (String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Object> variables(TaskRun taskRun) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"id", (Object)taskRun.getId()).put((Object)"startDate", (Object)taskRun.getState().getStartDate()).put((Object)"attemptsCount", (Object)(taskRun.getAttempts() == null ? 0 : taskRun.getAttempts().size()));
        if (taskRun.getParentTaskRunId() != null) {
            builder.put((Object)"parentId", (Object)taskRun.getParentTaskRunId());
        }
        if (taskRun.getValue() != null) {
            builder.put((Object)"value", (Object)taskRun.getValue());
        }
        return builder.build();
    }

    private Map<String, Object> variables(Task task) {
        return ImmutableMap.of((Object)"id", (Object)task.getId(), (Object)"type", (Object)task.getType());
    }

    public RunContext updateVariables(WorkerTaskResult workerTaskResult, TaskRun parent) {
        HashMap<String, Object> result;
        HashMap<String, Object> variables = new HashMap<String, Object>(this.variables);
        HashMap outputs = this.variables.containsKey("outputs") ? new HashMap((Map)this.variables.get("outputs")) : new HashMap();
        HashMap<String, Object> current = result = new HashMap<String, Object>();
        if (variables.containsKey("parents")) {
            for (Map t : Lists.reverse((List)((List)variables.get("parents")))) {
                if (t.get("taskrun") == null || ((Map)t.get("taskrun")).get("value") == null) continue;
                HashMap item = new HashMap();
                current.put((String)((Map)t.get("taskrun")).get("value"), item);
                current = item;
            }
        }
        if (parent.getValue() != null) {
            HashMap item = new HashMap();
            current.put(parent.getValue(), item);
            current = item;
        }
        if (workerTaskResult.getTaskRun().getOutputs() != null) {
            current.putAll(workerTaskResult.getTaskRun().getOutputs());
        }
        outputs.put(workerTaskResult.getTaskRun().getTaskId(), result);
        variables.remove("outputs");
        variables.put("outputs", outputs);
        return this.clone(variables);
    }

    private RunContext clone(Map<String, Object> variables) {
        RunContext runContext = new RunContext();
        runContext.variableRenderer = this.variableRenderer;
        runContext.applicationContext = this.applicationContext;
        runContext.storageInterface = this.storageInterface;
        runContext.storageOutputPrefix = this.storageOutputPrefix;
        runContext.storageExecutionPrefix = this.storageExecutionPrefix;
        runContext.envPrefix = this.envPrefix;
        runContext.variables = variables;
        runContext.metrics = new ArrayList();
        runContext.meterRegistry = this.meterRegistry;
        runContext.runContextLogger = this.runContextLogger;
        runContext.tempBasedPath = this.tempBasedPath;
        runContext.temporaryDirectory = this.temporaryDirectory;
        return runContext;
    }

    public RunContext forWorker(ApplicationContext applicationContext, WorkerTask workerTask) {
        this.initBean(applicationContext);
        this.initLogger(workerTask.getTaskRun());
        HashMap<String, Object> clone = new HashMap<String, Object>(this.variables);
        clone.remove("taskrun");
        clone.put("taskrun", this.variables(workerTask.getTaskRun()));
        clone.remove("task");
        clone.put("task", this.variables(workerTask.getTask()));
        this.variables = ImmutableMap.copyOf(clone);
        this.storageExecutionPrefix = URI.create("/" + this.storageInterface.executionPrefix(workerTask.getTaskRun()));
        return this;
    }

    public String render(String inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.variables);
    }

    public String render(String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.mergeVariables(variables));
    }

    public List<String> render(List<String> inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.variables);
    }

    public List<String> render(List<String> inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.mergeVariables(variables));
    }

    public Map<String, Object> render(Map<String, Object> inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.variables);
    }

    public Map<String, Object> render(Map<String, Object> inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.mergeVariables(variables));
    }

    private Map<String, Object> mergeVariables(Map<String, Object> variables) {
        return Stream.concat(this.variables.entrySet().stream(), variables.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, o2) -> o2));
    }

    public Logger logger() {
        return this.runContextLogger.logger();
    }

    public InputStream uriToInputStream(URI uri) throws IOException {
        if (uri.getScheme().equals("kestra")) {
            return this.storageInterface.get(uri);
        }
        throw new IllegalArgumentException("Invalid scheme for uri '" + uri + "'");
    }

    public URI putTempFile(File file) throws IOException {
        return this.putTempFile(file, this.storageOutputPrefix.toString(), (String)null);
    }

    public URI putTempFile(File file, String name) throws IOException {
        return this.putTempFile(file, this.storageOutputPrefix.toString(), name);
    }

    public URI putTempFile(File file, String executionId, AbstractTrigger trigger) throws IOException {
        return this.putTempFile(file, this.storageOutputPrefix.toString() + "/" + String.join((CharSequence)"/", Arrays.asList("executions", executionId, "trigger", Slugify.of(trigger.getId()))), (String)null);
    }

    private URI putTempFile(InputStream inputStream, String prefix, String name) throws IOException {
        URI uri = URI.create(prefix);
        URI resolve = uri.resolve(uri.getPath() + "/" + name);
        return this.storageInterface.put(resolve, new BufferedInputStream(inputStream));
    }

    private URI putTempFile(File file, String prefix, String name) throws IOException {
        URI put = this.putTempFile(new FileInputStream(file), prefix, name != null ? name : file.getName());
        boolean delete = file.delete();
        if (!delete) {
            this.runContextLogger.logger().warn("Failed to delete temporary file");
        }
        return put;
    }

    private String taskStateFilePathPrefix(String name, Boolean namespace) {
        Map taskrun = (Map)this.getVariables().get("taskrun");
        return "/" + this.storageInterface.statePrefix((String)((Map)this.getVariables().get("flow")).get("namespace"), namespace != false ? null : (String)((Map)this.getVariables().get("flow")).get("id"), name, taskrun != null ? (String)taskrun.getOrDefault("value", null) : null);
    }

    public InputStream getTaskStateFile(String state, String name) throws IOException {
        return this.getTaskStateFile(state, name, false);
    }

    public InputStream getTaskStateFile(String state, String name, Boolean namespace) throws IOException {
        URI uri = URI.create(this.taskStateFilePathPrefix(state, namespace));
        URI resolve = uri.resolve(uri.getPath() + "/" + name);
        return this.storageInterface.get(resolve);
    }

    public URI putTaskStateFile(byte[] content, String state, String name) throws IOException {
        return this.putTaskStateFile(content, state, name, (Boolean)false);
    }

    public URI putTaskStateFile(byte[] content, String state, String name, Boolean namespace) throws IOException {
        return this.putTempFile(new ByteArrayInputStream(content), this.taskStateFilePathPrefix(state, namespace), name);
    }

    public URI putTaskStateFile(File file, String state, String name) throws IOException {
        return this.putTaskStateFile(file, state, name, (Boolean)false);
    }

    public URI putTaskStateFile(File file, String state, String name, Boolean namespace) throws IOException {
        return this.putTempFile(file, this.taskStateFilePathPrefix(state, namespace), name);
    }

    public boolean deleteTaskStateFile(String state, String name) throws IOException {
        return this.deleteTaskStateFile(state, name, false);
    }

    public boolean deleteTaskStateFile(String state, String name, Boolean namespace) throws IOException {
        URI uri = URI.create(this.taskStateFilePathPrefix(state, namespace));
        URI resolve = uri.resolve(uri.getPath() + "/" + name);
        return this.storageInterface.delete(resolve);
    }

    public List<URI> purgeStorageExecution() throws IOException {
        return this.storageInterface.deleteByPrefix(this.storageExecutionPrefix);
    }

    public List<AbstractMetricEntry<?>> metrics() {
        return this.metrics;
    }

    public <T> RunContext metric(AbstractMetricEntry<T> metricEntry) {
        block4: {
            int index = this.metrics.indexOf(metricEntry);
            if (index >= 0) {
                AbstractMetricEntry<?> current = this.metrics.get(index);
                current.increment(metricEntry.getValue());
            } else {
                this.metrics.add(metricEntry);
            }
            try {
                metricEntry.register(this.meterRegistry, this.metricPrefix(), this.metricsTags());
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Collector already registered")) break block4;
                throw e;
            }
        }
        return this;
    }

    private Map<String, String> metricsTags() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.variables.containsKey("flow")) {
            builder.put((Object)"flow_id", (Object)((String)((Map)this.variables.get("flow")).get("id"))).put((Object)"namespace_id", (Object)((String)((Map)this.variables.get("flow")).get("namespace")));
        }
        return builder.build();
    }

    private String metricPrefix() {
        if (!this.variables.containsKey("task")) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(((String)((Map)this.variables.get("task")).get("type")).split("\\.")));
        String clsName = (String)values.remove(values.size() - 1);
        values.add(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, clsName));
        return String.join((CharSequence)".", values);
    }

    public void dynamicWorkerResult(List<WorkerTaskResult> workerTaskResults) {
        this.dynamicWorkerTaskResult.addAll(workerTaskResults);
    }

    public List<WorkerTaskResult> dynamicWorkerResults() {
        return this.dynamicWorkerTaskResult;
    }

    public synchronized Path tempDir() {
        return this.tempDir(true);
    }

    public synchronized Path tempDir(boolean create) {
        if (this.temporaryDirectory == null) {
            this.temporaryDirectory = this.tempBasedPath.resolve(IdUtils.create());
        }
        if (create && !this.temporaryDirectory.toFile().exists()) {
            this.temporaryDirectory.toFile().mkdirs();
        }
        return this.temporaryDirectory;
    }

    public Path tempFile() throws IOException {
        return this.tempFile(null, null);
    }

    public Path tempFile(String suffix) throws IOException {
        return this.tempFile(null, suffix);
    }

    public Path tempFile(byte[] content) throws IOException {
        return this.tempFile(content, null);
    }

    public Path tempFile(byte[] content, String suffix) throws IOException {
        Path tempFile = Files.createTempFile(this.tempDir(), null, suffix, new FileAttribute[0]);
        if (content != null) {
            Files.write(tempFile, content, new OpenOption[0]);
        }
        return tempFile;
    }

    public void cleanup() {
        try {
            this.cleanTemporaryDirectory();
        }
        catch (IOException ex) {
            this.logger().warn("Unable to cleanup worker task", (Throwable)ex);
        }
    }

    private void cleanTemporaryDirectory() throws IOException {
        if (this.temporaryDirectory != null && this.temporaryDirectory.toFile().exists()) {
            FileUtils.deleteDirectory((File)this.temporaryDirectory.toFile());
            this.temporaryDirectory = null;
        }
    }

    @Generated
    public RunContext() {
    }
}

