/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.handlebars.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.internal.lang3.LocaleUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public enum DateHelper implements Helper<Object>
{
    dateFormat{

        public CharSequence apply(Object value, Options options) {
            ZoneId zoneId = DateHelper.zoneId(options);
            ZonedDateTime date = DateHelper.zonedDateTime(value, zoneId);
            String format = (String)options.param(0, (Object)((String)options.hash("format", (Object)"iso")));
            String localeStr = (String)options.param(1, (Object)Locale.getDefault().toString());
            return DateHelper.format(date, format, zoneId, localeStr);
        }
    }
    ,
    now{

        public Object apply(Object value, Options options) throws IOException {
            ZoneId zoneId = DateHelper.zoneId(options);
            ZonedDateTime date = ZonedDateTime.now(DateHelper.zoneId(options));
            String format = (String)options.param(0, (Object)((String)options.hash("format", value instanceof String ? value : "iso")));
            String localeStr = (String)options.param(1, (Object)Locale.getDefault().toString());
            return DateHelper.format(date, format, zoneId, localeStr);
        }
    }
    ,
    timestamp{

        public CharSequence apply(Object value, Options options) {
            return String.valueOf(DateHelper.zonedDateTime(value, DateHelper.zoneId(options)).toEpochSecond());
        }
    }
    ,
    nanotimestamp{

        public CharSequence apply(Object value, Options options) {
            ZonedDateTime date = DateHelper.zonedDateTime(value, DateHelper.zoneId(options));
            return String.valueOf(TimeUnit.SECONDS.toNanos(date.toEpochSecond()) + (long)date.getNano());
        }
    }
    ,
    microtimestamp{

        public CharSequence apply(Object value, Options options) {
            ZonedDateTime date = DateHelper.zonedDateTime(value, DateHelper.zoneId(options));
            return String.valueOf(TimeUnit.SECONDS.toNanos(date.toEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(date.getNano()));
        }
    }
    ,
    dateAdd{

        public Object apply(Object value, Options options) throws IOException {
            ZonedDateTime date = DateHelper.zonedDateTime(value, DateHelper.zoneId(options));
            ZoneId zoneId = DateHelper.zoneId(options);
            Integer amount = (Integer)options.param(0, (Object)((Integer)options.hash("amount")));
            String unit = (String)options.param(1, (Object)((String)options.hash("unit")));
            String format = (String)options.param(2, (Object)((String)options.hash("format", (Object)"iso")));
            String localeStr = (String)options.param(2, (Object)Locale.getDefault().toString());
            ZonedDateTime plus = date.plus(amount.intValue(), ChronoUnit.valueOf(unit));
            return DateHelper.format(plus, format, zoneId, localeStr);
        }
    };

    private static final Map<String, FormatStyle> styles;
    private static final Map<String, DateTimeFormatter> formatters;

    private static String format(ZonedDateTime date, String format, ZoneId zoneId, String localeStr) {
        DateTimeFormatter formatterFind = formatters.get(format);
        FormatStyle styleFind = styles.get(format);
        DateTimeFormatter formatter = styleFind != null ? DateTimeFormatter.ofLocalizedDateTime(styleFind) : (formatterFind != null ? formatterFind : DateTimeFormatter.ofPattern(format));
        Locale locale = LocaleUtils.toLocale((String)localeStr);
        formatter = formatter.withLocale(locale);
        formatter = formatter.withZone(zoneId);
        return formatter.format(date);
    }

    private static ZonedDateTime zonedDateTime(Object value, ZoneId zoneId) {
        ZonedDateTime date = value instanceof Date ? ZonedDateTime.ofInstant(((Date)value).toInstant(), zoneId) : (value instanceof Instant ? ((Instant)value).atZone(zoneId) : (value instanceof LocalDateTime ? ZonedDateTime.of((LocalDateTime)value, zoneId) : (value instanceof LocalDate ? ZonedDateTime.of((LocalDate)value, LocalTime.NOON, zoneId) : (value instanceof ZonedDateTime ? (ZonedDateTime)value : ZonedDateTime.parse((String)value)))));
        return date;
    }

    private static ZoneId zoneId(Options options) {
        Object tz = options.hash("tz");
        if (tz != null) {
            return tz instanceof ZoneId ? (ZoneId)tz : ZoneId.of(tz.toString());
        }
        return ZoneId.systemDefault();
    }

    static {
        styles = ImmutableMap.of((Object)"full", (Object)((Object)FormatStyle.FULL), (Object)"long", (Object)((Object)FormatStyle.LONG), (Object)"medium", (Object)((Object)FormatStyle.MEDIUM), (Object)"short", (Object)((Object)FormatStyle.SHORT));
        formatters = ImmutableMap.builder().put((Object)"iso", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX")).put((Object)"iso_sec", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX")).put((Object)"sql", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS")).put((Object)"sql_seq", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).put((Object)"iso_date_time", (Object)DateTimeFormatter.ISO_DATE_TIME).put((Object)"iso_date", (Object)DateTimeFormatter.ISO_DATE).put((Object)"iso_time", (Object)DateTimeFormatter.ISO_TIME).put((Object)"iso_local_date", (Object)DateTimeFormatter.ISO_LOCAL_DATE).put((Object)"iso_instant", (Object)DateTimeFormatter.ISO_INSTANT).put((Object)"iso_local_date_time", (Object)DateTimeFormatter.ISO_LOCAL_DATE_TIME).put((Object)"iso_local_time", (Object)DateTimeFormatter.ISO_LOCAL_TIME).put((Object)"iso_offset_time", (Object)DateTimeFormatter.ISO_OFFSET_TIME).put((Object)"iso_ordinal_date", (Object)DateTimeFormatter.ISO_ORDINAL_DATE).put((Object)"iso_week_date", (Object)DateTimeFormatter.ISO_WEEK_DATE).put((Object)"iso_zoned_date_time", (Object)DateTimeFormatter.ISO_ZONED_DATE_TIME).put((Object)"rfc_1123_date_time", (Object)DateTimeFormatter.RFC_1123_DATE_TIME).build();
    }
}

