/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import com.github.jknack.handlebars.internal.lang3.LocaleUtils;
import com.google.common.collect.ImmutableMap;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractDate {
    private static final Map<String, DateTimeFormatter> FORMATTERS = ImmutableMap.builder().put((Object)"iso", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX")).put((Object)"iso_sec", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX")).put((Object)"sql", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS")).put((Object)"sql_seq", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).put((Object)"iso_date_time", (Object)DateTimeFormatter.ISO_DATE_TIME).put((Object)"iso_date", (Object)DateTimeFormatter.ISO_DATE).put((Object)"iso_time", (Object)DateTimeFormatter.ISO_TIME).put((Object)"iso_local_date", (Object)DateTimeFormatter.ISO_LOCAL_DATE).put((Object)"iso_instant", (Object)DateTimeFormatter.ISO_INSTANT).put((Object)"iso_local_date_time", (Object)DateTimeFormatter.ISO_LOCAL_DATE_TIME).put((Object)"iso_local_time", (Object)DateTimeFormatter.ISO_LOCAL_TIME).put((Object)"iso_offset_time", (Object)DateTimeFormatter.ISO_OFFSET_TIME).put((Object)"iso_ordinal_date", (Object)DateTimeFormatter.ISO_ORDINAL_DATE).put((Object)"iso_week_date", (Object)DateTimeFormatter.ISO_WEEK_DATE).put((Object)"iso_zoned_date_time", (Object)DateTimeFormatter.ISO_ZONED_DATE_TIME).put((Object)"rfc_1123_date_time", (Object)DateTimeFormatter.RFC_1123_DATE_TIME).build();
    private static final Map<String, FormatStyle> STYLES = ImmutableMap.of((Object)"full", (Object)((Object)FormatStyle.FULL), (Object)"long", (Object)((Object)FormatStyle.LONG), (Object)"medium", (Object)((Object)FormatStyle.MEDIUM), (Object)"short", (Object)((Object)FormatStyle.SHORT));

    public List<String> getArgumentNames() {
        return List.of("format", "timeZone", "existingFormat", "locale");
    }

    protected static String format(Object input, Map<String, Object> args, EvaluationContext context) {
        String format = args.containsKey("format") ? (String)args.get("format") : "iso";
        String timeZone = (String)args.get("timeZone");
        String existingFormat = (String)args.get("existingFormat");
        Locale locale = args.containsKey("locale") ? LocaleUtils.toLocale((String)((String)args.get("locale"))) : context.getLocale();
        ZoneId zoneId = AbstractDate.zoneId(timeZone);
        ZonedDateTime date = AbstractDate.convert(input, zoneId, existingFormat);
        DateTimeFormatter formatter = AbstractDate.formatter(format).withLocale(locale).withZone(zoneId);
        return formatter.format(date);
    }

    private static DateTimeFormatter formatter(String format) {
        DateTimeFormatter formatterFind = FORMATTERS.get(format);
        FormatStyle styleFind = STYLES.get(format);
        if (styleFind != null) {
            return DateTimeFormatter.ofLocalizedDateTime(styleFind);
        }
        if (formatterFind != null) {
            return formatterFind;
        }
        return DateTimeFormatter.ofPattern(format);
    }

    protected static ZoneId zoneId(String input) {
        if (input != null) {
            return ZoneId.of(input);
        }
        return ZoneId.systemDefault();
    }

    protected static ZonedDateTime convert(Object value, ZoneId zoneId, String existingFormat) {
        if (value instanceof Date) {
            return ZonedDateTime.ofInstant(((Date)value).toInstant(), zoneId);
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(zoneId);
        }
        if (value instanceof LocalDateTime) {
            return ZonedDateTime.of((LocalDateTime)value, zoneId);
        }
        if (value instanceof LocalDate) {
            return ZonedDateTime.of((LocalDate)value, LocalTime.NOON, zoneId);
        }
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof Long) {
            return Instant.ofEpochSecond((Long)value).atZone(zoneId);
        }
        try {
            if (existingFormat != null) {
                return ZonedDateTime.parse((String)value, AbstractDate.formatter(existingFormat));
            }
            return ZonedDateTime.parse((String)value);
        }
        catch (DateTimeParseException e) {
            try {
                if (existingFormat != null) {
                    return LocalDateTime.parse((String)value, AbstractDate.formatter(existingFormat)).atZone(zoneId);
                }
                return LocalDateTime.parse((String)value).atZone(zoneId);
            }
            catch (DateTimeParseException e2) {
                if (existingFormat != null) {
                    return LocalDate.parse((String)value, AbstractDate.formatter(existingFormat)).atStartOfDay().atZone(zoneId);
                }
                return LocalDate.parse((String)value).atStartOfDay().atZone(zoneId);
            }
        }
    }
}

