/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import io.kestra.core.runners.pebble.AbstractDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;

public class DateAddFilter
extends AbstractDate
implements Filter {
    @Override
    public List<String> getArgumentNames() {
        return List.of("amount", "unit", "format", "timeZone", "existingFormat", "locale");
    }

    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        Long amount = (Long)args.get("amount");
        String unit = (String)args.get("unit");
        String timeZone = (String)args.get("timeZone");
        String existingFormat = (String)args.get("existingFormat");
        ZoneId zoneId = DateAddFilter.zoneId(timeZone);
        ZonedDateTime date = DateAddFilter.convert(input, zoneId, existingFormat);
        ZonedDateTime plus = date.plus(amount, ChronoUnit.valueOf(unit));
        return DateAddFilter.format(plus, args, context);
    }
}

