/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberFilter
implements Filter {
    public List<String> getArgumentNames() {
        return List.of("type");
    }

    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String)) {
            throw new PebbleException(null, "'number' filter can only be applied to String. Actual type was: " + input.getClass().getName(), Integer.valueOf(lineNumber), self.getName());
        }
        String type = (String)args.getOrDefault("type", "");
        String val = (String)input;
        switch (type) {
            case "INT": {
                return NumberUtils.createInteger((String)val);
            }
            case "FLOAT": {
                return NumberUtils.createFloat((String)val);
            }
            case "LONG": {
                return NumberUtils.createLong((String)val);
            }
            case "DOUBLE": {
                return NumberUtils.createDouble((String)val);
            }
            case "BIGDECIMAL": {
                return NumberUtils.createBigDecimal((String)val);
            }
            case "BIGINTEGER": {
                return NumberUtils.createBigInteger((String)val);
            }
        }
        return NumberUtils.createNumber((String)val);
    }
}

