/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.util.List;
import java.util.Map;

public class JsonFunction
implements Function {
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<Object> TYPE_REFERENCE = new TypeReference<Object>(){};

    public List<String> getArgumentNames() {
        return List.of("json");
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        if (!args.containsKey("json")) {
            throw new PebbleException(null, "The 'json' function expects an argument 'json'.", Integer.valueOf(lineNumber), self.getName());
        }
        if (!(args.get("json") instanceof String)) {
            throw new PebbleException(null, "The 'json' function expects an argument 'json' with type string.", Integer.valueOf(lineNumber), self.getName());
        }
        String json = (String)args.get("json");
        try {
            return MAPPER.readValue(json, TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new PebbleException(null, "Invalid json: " + e.getMessage(), Integer.valueOf(lineNumber), self.getName());
        }
    }
}

