/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.serializers.helpers.HandleBarDeserializer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import org.apache.commons.io.FilenameUtils;

@Singleton
public class YamlFlowParser {
    public static final String CONTEXT_FLOW_DIRECTORY = "flowDirectory";
    private static final ObjectMapper mapper = JacksonMapper.ofYaml().disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).registerModule((Module)new SimpleModule("HandleBarDeserializer").addDeserializer(String.class, (JsonDeserializer)new HandleBarDeserializer()));
    @Inject
    private ModelValidator modelValidator;

    public static boolean isValidExtension(Path path) {
        return FilenameUtils.getExtension((String)path.toFile().getAbsolutePath()).equals("yaml") || FilenameUtils.getExtension((String)path.toFile().getAbsolutePath()).equals("yml");
    }

    public Flow parse(File file) throws ConstraintViolationException {
        Flow flow = this.readFile(file);
        this.modelValidator.isValid(flow).ifPresent(e -> {
            throw new ConstraintViolationException("Invalid flow '" + flow.getNamespace() + "." + flow.getId() + "', error: " + e.getConstraintViolations().stream().map(r -> r.getPropertyPath() + ":" + r.getMessage()).collect(Collectors.joining("\n -")), e.getConstraintViolations());
        });
        return flow;
    }

    private Flow readFile(File file) {
        try {
            return (Flow)mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(CONTEXT_FLOW_DIRECTORY, (Object)file.getAbsoluteFile().getParentFile().getAbsolutePath())).readValue(file, Flow.class);
        }
        catch (JsonMappingException e) {
            if (e.getCause() instanceof ConstraintViolationException) {
                throw (ConstraintViolationException)e.getCause();
            }
            throw new ConstraintViolationException("Illegal flow yaml:" + e.getMessage(), Collections.singleton(ManualConstraintViolation.of(e.getMessage(), file, File.class, "flow", file.getAbsolutePath())));
        }
        catch (IOException e) {
            throw new ConstraintViolationException("Illegal flow path:" + e.getMessage(), Collections.singleton(ManualConstraintViolation.of(e.getMessage(), file, File.class, "flow", file.getAbsolutePath())));
        }
    }
}

