/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers.ion;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.kestra.core.serializers.ion.IonGenerator;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;

public class IonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Version VERSION = VersionUtil.parseVersion((String)"0.0.1", (String)"io.kestra", (String)"core");

    public IonModule() {
        super(VERSION);
        this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
        this.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        this.addSerializer(OffsetDateTime.class, (JsonSerializer)new StringTypedSerializer<OffsetDateTime>(OffsetDateTime.class, o -> o.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        this.addSerializer(ZonedDateTime.class, (JsonSerializer)new StringTypedSerializer<ZonedDateTime>(ZonedDateTime.class, o -> o.format(DateTimeFormatter.ISO_ZONED_DATE_TIME)));
        this.addSerializer(LocalDateTime.class, (JsonSerializer)new StringTypedSerializer<LocalDateTime>(LocalDateTime.class, o -> o.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)));
        this.addSerializer(OffsetTime.class, (JsonSerializer)new StringTypedSerializer<OffsetTime>(OffsetTime.class, o -> o.format(DateTimeFormatter.ISO_OFFSET_TIME)));
        this.addSerializer(LocalTime.class, (JsonSerializer)new StringTypedSerializer<LocalTime>(LocalTime.class, o -> o.format(DateTimeFormatter.ISO_LOCAL_TIME)));
    }

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
    }

    public static class LocalDateSerializer
    extends StdScalarSerializer<LocalDate> {
        private static final long serialVersionUID = 1L;

        protected LocalDateSerializer() {
            super(LocalDate.class);
        }

        public void serialize(LocalDate date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            ((IonGenerator)jsonGenerator).writeDate(date);
        }
    }

    public static class InstantSerializer
    extends StdScalarSerializer<Instant> {
        private static final long serialVersionUID = 1L;

        protected InstantSerializer() {
            super(Instant.class);
        }

        public void serialize(Instant date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            ((IonGenerator)jsonGenerator).writeDate(date);
        }
    }

    public static class StringTypedSerializer<T>
    extends StdScalarSerializer<T> {
        private static final long serialVersionUID = 1L;
        private final Function<T, String> mapper;

        protected StringTypedSerializer(Class<T> cls, Function<T, String> mapper) {
            super(cls);
            this.mapper = mapper;
        }

        public void serialize(T value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            ((IonGenerator)jsonGenerator).writeString(value, this.mapper.apply(value));
        }
    }
}

