/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.ServerType;
import io.kestra.core.models.collectors.ConfigurationUsage;
import io.kestra.core.models.collectors.ExecutionUsage;
import io.kestra.core.models.collectors.FlowUsage;
import io.kestra.core.models.collectors.HostUsage;
import io.kestra.core.models.collectors.PluginUsage;
import io.kestra.core.models.collectors.Result;
import io.kestra.core.models.collectors.Usage;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.InstanceService;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.VersionProvider;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.rxjava2.http.client.RxHttpClient;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CollectorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollectorService.class);
    private static final String UUID = IdUtils.create();
    @Inject
    @Client
    protected RxHttpClient client;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private ExecutionRepositoryInterface executionRepository;
    @Inject
    private InstanceService instanceService;
    @Inject
    private VersionProvider versionProvider;
    @Nullable
    @Value(value="${kestra.server-type}")
    protected ServerType serverType;
    @Nullable
    @Value(value="${kestra.url:}")
    private String kestraUrl;
    @Value(value="${kestra.anonymous-usage-report.uri}")
    protected URI url;
    private transient Usage defaultUsage;

    protected synchronized Usage defaultUsage() {
        boolean first;
        boolean bl = first = this.defaultUsage == null;
        if (first) {
            this.defaultUsage = ((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)((Usage.UsageBuilder)Usage.builder().startUuid(UUID)).instanceUuid(this.instanceService.fetch())).serverType(this.serverType)).version(this.versionProvider.getVersion())).zoneId(ZoneId.systemDefault())).uri(this.kestraUrl == null ? null : this.kestraUrl)).environments(this.applicationContext.getEnvironment().getActiveNames())).startTime(Instant.ofEpochMilli(ManagementFactory.getRuntimeMXBean().getStartTime()))).host(HostUsage.of())).configurations(ConfigurationUsage.of(this.applicationContext))).plugins(PluginUsage.of(this.applicationContext))).build();
        }
        return this.defaultUsage;
    }

    public Usage metrics() {
        Object builder = this.defaultUsage().toBuilder().uuid(IdUtils.create());
        if (this.serverType == ServerType.EXECUTOR || this.serverType == ServerType.STANDALONE) {
            ((Usage.UsageBuilder)((Usage.UsageBuilder)builder).flows(FlowUsage.of(this.flowRepository))).executions(ExecutionUsage.of(this.executionRepository));
        }
        return ((Usage.UsageBuilder)builder).build();
    }

    public void report() {
        try {
            Usage metrics = this.metrics();
            MutableHttpRequest<Usage> post = this.request(metrics);
            if (log.isTraceEnabled()) {
                log.trace("Report anonymous usage: '{}'", (Object)JacksonMapper.ofJson().writeValueAsString((Object)metrics));
            }
            Result result = (Result)this.client.toBlocking().retrieve(post, Argument.of(Result.class), Argument.of(JsonError.class));
            this.handleResponse(result);
        }
        catch (HttpClientResponseException t) {
            log.warn("Unable to report anonymous usage with body '{}'", (Object)t.getResponse().getBody(String.class), (Object)t);
        }
        catch (Exception t) {
            log.error("Unable to handle anonymous usage", (Throwable)t);
        }
    }

    private void handleResponse(Result result) {
    }

    protected MutableHttpRequest<Usage> request(Usage metrics) throws Exception {
        return HttpRequest.POST((URI)this.url, (Object)metrics).header((CharSequence)"User-Agent", (CharSequence)("Kestra/" + this.versionProvider.getVersion()));
    }
}

