/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.types.MultipleCondition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.kestra.core.models.triggers.types.Flow;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.ListUtils;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Singleton
public class FlowService {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    ConditionService conditionService;
    @Inject
    ApplicationContext applicationContext;

    public Stream<io.kestra.core.models.flows.Flow> keepLastVersion(Stream<io.kestra.core.models.flows.Flow> stream) {
        return this.keepLastVersionCollector(stream);
    }

    public io.kestra.core.models.flows.Flow keepLastVersion(Stream<io.kestra.core.models.flows.Flow> stream, String namespace, String flowId) {
        return this.keepLastVersionCollector(stream.filter(flow -> flow.getNamespace().equals(namespace) && flow.getId().equals(flowId))).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find flow '" + namespace + "." + flowId + "'"));
    }

    public Collection<io.kestra.core.models.flows.Flow> keepLastVersion(List<io.kestra.core.models.flows.Flow> flows) {
        return this.keepLastVersionCollector(flows.stream()).collect(Collectors.toList());
    }

    private Stream<io.kestra.core.models.flows.Flow> keepLastVersionCollector(Stream<io.kestra.core.models.flows.Flow> stream) {
        return stream.sorted((left, right) -> left.getRevision() > right.getRevision() ? -1 : (left.getRevision().equals(right.getRevision()) ? 0 : 1)).collect(Collectors.groupingBy(io.kestra.core.models.flows.Flow::uidWithoutRevision)).values().stream().map(flows -> {
            io.kestra.core.models.flows.Flow flow;
            io.kestra.core.models.flows.Flow finalFlow = flow = (io.kestra.core.models.flows.Flow)flows.stream().findFirst().orElseThrow();
            Optional<io.kestra.core.models.flows.Flow> deleted = flows.stream().filter(f -> f.getRevision().equals(finalFlow.getRevision()) && f.isDeleted()).findFirst();
            if (deleted.isPresent()) {
                return null;
            }
            return flow.isDeleted() ? null : flow;
        }).filter(Objects::nonNull);
    }

    public List<FlowWithFlowTrigger> flowWithFlowTrigger(Stream<io.kestra.core.models.flows.Flow> flowStream) {
        return flowStream.filter(flow -> flow.getTriggers() != null && flow.getTriggers().size() > 0).filter(flow -> !flow.isDisabled()).flatMap(flow -> flow.getTriggers().stream().filter(abstractTrigger -> !abstractTrigger.isDisabled()).map(trigger -> new FlowWithTrigger((io.kestra.core.models.flows.Flow)flow, (AbstractTrigger)trigger))).filter(f -> f.getTrigger() instanceof Flow).map(f -> new FlowWithFlowTrigger(f.getFlow(), (Flow)f.getTrigger())).collect(Collectors.toList());
    }

    protected boolean removeUnwanted(io.kestra.core.models.flows.Flow f, Execution execution) {
        return !f.uidWithoutRevision().equals(io.kestra.core.models.flows.Flow.uidWithoutRevision(execution));
    }

    public List<Execution> flowTriggerExecution(Stream<io.kestra.core.models.flows.Flow> flowStream, Execution execution, MultipleConditionStorageInterface multipleConditionStorage) {
        return flowStream.filter(flow -> flow.getTriggers() != null && flow.getTriggers().size() > 0).filter(flow -> !flow.isDisabled()).flatMap(flow -> flow.getTriggers().stream().filter(abstractTrigger -> !abstractTrigger.isDisabled()).map(trigger -> new FlowWithTrigger((io.kestra.core.models.flows.Flow)flow, (AbstractTrigger)trigger))).filter(f -> this.conditionService.isValid(f.getTrigger(), f.getFlow(), execution, multipleConditionStorage)).filter(f -> f.getTrigger() instanceof Flow).map(f -> new FlowWithFlowTrigger(f.getFlow(), (Flow)f.getTrigger())).filter(f -> this.removeUnwanted(f.getFlow(), execution)).map(f -> f.getTrigger().evaluate(this.runContextFactory.of(f.getFlow(), execution), f.getFlow(), execution)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Stream<FlowWithFlowTriggerAndMultipleCondition> multipleFlowStream(Stream<io.kestra.core.models.flows.Flow> flowStream, MultipleConditionStorageInterface multipleConditionStorage) {
        return this.flowWithFlowTrigger(flowStream).stream().flatMap(e -> e.getTrigger().getConditions().stream().filter(condition -> condition instanceof MultipleCondition).map(condition -> {
            MultipleCondition multipleCondition = (MultipleCondition)condition;
            return new FlowWithFlowTriggerAndMultipleCondition(e.getFlow(), multipleConditionStorage.getOrCreate(e.getFlow(), multipleCondition), e.getTrigger(), multipleCondition);
        }));
    }

    public List<MultipleConditionWindow> multipleFlowTrigger(Stream<io.kestra.core.models.flows.Flow> flowStream, io.kestra.core.models.flows.Flow flow, Execution execution, MultipleConditionStorageInterface multipleConditionStorage) {
        return this.multipleFlowStream(flowStream, multipleConditionStorage).map(f -> {
            Map<String, Boolean> results = f.getMultipleCondition().getConditions().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Boolean>((String)e.getKey(), this.conditionService.isValid((Condition)e.getValue(), flow, execution))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return f.getMultipleConditionWindow().with(results);
        }).filter(multipleConditionWindow -> multipleConditionWindow.getResults().size() > 0).collect(Collectors.toList());
    }

    public List<MultipleConditionWindow> multipleFlowToDelete(Stream<io.kestra.core.models.flows.Flow> flowStream, MultipleConditionStorageInterface multipleConditionStorage) {
        return Stream.concat(this.multipleFlowStream(flowStream, multipleConditionStorage).filter(f -> (long)f.getMultipleCondition().getConditions().size() == (f.getMultipleConditionWindow().getResults() == null ? 0L : f.getMultipleConditionWindow().getResults().entrySet().stream().filter(Map.Entry::getValue).count())).map(FlowWithFlowTriggerAndMultipleCondition::getMultipleConditionWindow), multipleConditionStorage.expired().stream()).collect(Collectors.toList());
    }

    public static List<AbstractTrigger> findRemovedTrigger(io.kestra.core.models.flows.Flow flow, io.kestra.core.models.flows.Flow previous) {
        return ListUtils.emptyOnNull(previous.getTriggers()).stream().filter(p -> ListUtils.emptyOnNull(flow.getTriggers()).stream().noneMatch(c -> c.getId().equals(p.getId()))).collect(Collectors.toList());
    }

    private static class FlowWithFlowTriggerAndMultipleCondition {
        private final io.kestra.core.models.flows.Flow flow;
        private final MultipleConditionWindow multipleConditionWindow;
        private final Flow trigger;
        private final MultipleCondition multipleCondition;

        @ConstructorProperties(value={"flow", "multipleConditionWindow", "trigger", "multipleCondition"})
        @Generated
        public FlowWithFlowTriggerAndMultipleCondition(io.kestra.core.models.flows.Flow flow, MultipleConditionWindow multipleConditionWindow, Flow trigger, MultipleCondition multipleCondition) {
            this.flow = flow;
            this.multipleConditionWindow = multipleConditionWindow;
            this.trigger = trigger;
            this.multipleCondition = multipleCondition;
        }

        @Generated
        public io.kestra.core.models.flows.Flow getFlow() {
            return this.flow;
        }

        @Generated
        public MultipleConditionWindow getMultipleConditionWindow() {
            return this.multipleConditionWindow;
        }

        @Generated
        public Flow getTrigger() {
            return this.trigger;
        }

        @Generated
        public MultipleCondition getMultipleCondition() {
            return this.multipleCondition;
        }

        @Generated
        public String toString() {
            return "FlowService.FlowWithFlowTriggerAndMultipleCondition(flow=" + this.getFlow() + ", multipleConditionWindow=" + this.getMultipleConditionWindow() + ", trigger=" + this.getTrigger() + ", multipleCondition=" + this.getMultipleCondition() + ")";
        }
    }

    public static class FlowWithFlowTrigger {
        private final io.kestra.core.models.flows.Flow flow;
        private final Flow trigger;

        @ConstructorProperties(value={"flow", "trigger"})
        @Generated
        public FlowWithFlowTrigger(io.kestra.core.models.flows.Flow flow, Flow trigger) {
            this.flow = flow;
            this.trigger = trigger;
        }

        @Generated
        public io.kestra.core.models.flows.Flow getFlow() {
            return this.flow;
        }

        @Generated
        public Flow getTrigger() {
            return this.trigger;
        }

        @Generated
        public String toString() {
            return "FlowService.FlowWithFlowTrigger(flow=" + this.getFlow() + ", trigger=" + this.getTrigger() + ")";
        }
    }

    private static class FlowWithTrigger {
        private final io.kestra.core.models.flows.Flow flow;
        private final AbstractTrigger trigger;

        @ConstructorProperties(value={"flow", "trigger"})
        @Generated
        public FlowWithTrigger(io.kestra.core.models.flows.Flow flow, AbstractTrigger trigger) {
            this.flow = flow;
            this.trigger = trigger;
        }

        @Generated
        public io.kestra.core.models.flows.Flow getFlow() {
            return this.flow;
        }

        @Generated
        public AbstractTrigger getTrigger() {
            return this.trigger;
        }
    }
}

