/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.google.common.collect.Lists;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.TaskDefault;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.TaskGlobalDefaultConfiguration;
import io.kestra.core.utils.MapUtils;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Singleton
public class TaskDefaultService {
    @Nullable
    @Inject
    protected TaskGlobalDefaultConfiguration globalDefault;
    @Inject
    @Named(value="workerTaskLogQueue")
    protected QueueInterface<LogEntry> logQueue;

    protected List<TaskDefault> mergeAllDefaults(Flow flow) {
        ArrayList<TaskDefault> list = new ArrayList<TaskDefault>();
        if (this.globalDefault != null && this.globalDefault.getDefaults() != null) {
            list.addAll(this.globalDefault.getDefaults());
        }
        if (flow.getTaskDefaults() != null) {
            list.addAll(flow.getTaskDefaults());
        }
        return list;
    }

    private static Map<String, List<TaskDefault>> taskDefaultsToMap(List<TaskDefault> taskDefaults) {
        return taskDefaults.stream().collect(Collectors.groupingBy(TaskDefault::getType));
    }

    public Flow injectDefaults(Flow flow, Execution execution) {
        try {
            return this.injectDefaults(flow);
        }
        catch (Exception e) {
            RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(execution)).forEach(this.logQueue::emit);
            return flow;
        }
    }

    public Flow injectDefaults(Flow flow, Logger logger) {
        try {
            return this.injectDefaults(flow);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return flow;
        }
    }

    Flow injectDefaults(Flow flow) {
        Map flowAsMap = JacksonMapper.toMap(flow);
        List<TaskDefault> allDefaults = this.mergeAllDefaults(flow);
        Map allDefaultsGroup = allDefaults.stream().collect(Collectors.groupingBy(TaskDefault::isForced, Collectors.toList()));
        Map<String, List<TaskDefault>> defaults = TaskDefaultService.taskDefaultsToMap(allDefaultsGroup.getOrDefault(false, new ArrayList()));
        Map<String, List<TaskDefault>> forced = TaskDefaultService.taskDefaultsToMap(Lists.reverse((List)allDefaultsGroup.getOrDefault(true, new ArrayList())));
        Object taskDefaults = flowAsMap.get("taskDefaults");
        if (taskDefaults != null) {
            flowAsMap.remove("taskDefaults");
        }
        if (defaults.size() > 0) {
            flowAsMap = (Map)TaskDefaultService.recursiveDefaults(flowAsMap, defaults);
        }
        if (forced.size() > 0) {
            flowAsMap = (Map)TaskDefaultService.recursiveDefaults(flowAsMap, forced);
        }
        if (taskDefaults != null) {
            flowAsMap.put("taskDefaults", taskDefaults);
        }
        return JacksonMapper.toMap((Object)flowAsMap, Flow.class);
    }

    private static Object recursiveDefaults(Object object, Map<String, List<TaskDefault>> defaults) {
        if (object instanceof Map) {
            Map<?, ?> value = (Map<?, ?>)object;
            if (value.containsKey("type")) {
                value = TaskDefaultService.defaults(value, defaults);
            }
            return value.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), TaskDefaultService.recursiveDefaults(e.getValue(), defaults))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (object instanceof Collection) {
            Collection value = (Collection)object;
            return value.stream().map(r -> TaskDefaultService.recursiveDefaults(r, defaults)).collect(Collectors.toList());
        }
        return object;
    }

    protected static Map<?, ?> defaults(Map<?, ?> task, Map<String, List<TaskDefault>> defaults) {
        Object type = task.get("type");
        if (!(type instanceof String)) {
            return task;
        }
        String taskType = (String)type;
        if (!defaults.containsKey(taskType)) {
            return task;
        }
        Map<String, Object> result = task;
        for (TaskDefault taskDefault : defaults.get(taskType)) {
            if (taskDefault.isForced()) {
                result = MapUtils.merge(result, taskDefault.getValues());
                continue;
            }
            result = MapUtils.merge(taskDefault.getValues(), result);
        }
        return result;
    }
}

