/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.executions;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.statistics.ExecutionCount;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="List execution counts for a list of flow", description="Mostly use for send an alert if a conditions is meet about execution counts.")
@Plugin(examples={@Example(title="Send a slack notification if no execution for a flow on last 24h", full=true, code={"id: executions-count", "namespace: io.kestra.tests", "", "tasks:", "  - id: counts", "    type: io.kestra.core.tasks.executions.Counts", "    expression: \"{{ count == 0 }}\"", "    flows:", "      - namespace: io.kestra.tests", "        flowId: logs", "    startDate: \"{{ now() | dateAdd(-1, 'DAYS') }}\"", "  - id: each_parallel", "    type: io.kestra.core.tasks.flows.EachParallel", "    tasks:", "      - id: slack_incoming_webhook", "        type: io.kestra.plugin.notifications.slack.SlackIncomingWebhook", "        payload: |", "          {", "            \"channel\": \"#run-channel\",", "            \"text\": \":warning: Flow `{{ jq taskrun.value '.namespace' true }}`.`{{ jq taskrun.value '.flowId' true }}` has no execution on last 24h !\"", "          }", "        url: \"https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX\"", "    value: \"{{ jq outputs.counts.results '. | select(. != null) | .[]' }}\"", "", "triggers:", "  - id: schedule", "    type: io.kestra.core.models.triggers.types.Schedule", "    backfill: {}", "    cron: \"0 4 * * * \""})})
public class Counts
extends Task
implements RunnableTask<Output> {
    @NotNull
    @NotEmpty
    @Schema(title="A list of flows to be filtered")
    @PluginProperty(dynamic=false)
    protected List<Flow> flows;
    @Schema(title="A list of state to be filtered")
    @PluginProperty(dynamic=false)
    protected List<State.Type> states;
    @NotNull
    @Schema(title="The start date")
    @PluginProperty(dynamic=true)
    protected String startDate;
    @Schema(title="The end date")
    @PluginProperty(dynamic=true)
    protected String endDate;
    @NotNull
    @Schema(title="The expression against each flows to look at", description="The expression is as handlebars expression must return `true` in order to keep the current line\nsome examples: \n- `{{ eq count 0 }}`: no execution found\n- `{{ gte count 5 }}`: more than 5 executions\n")
    @PluginProperty(dynamic=true)
    protected String expression;

    @Override
    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        ExecutionRepositoryInterface executionRepository = (ExecutionRepositoryInterface)runContext.getApplicationContext().getBean(ExecutionRepositoryInterface.class);
        List<ExecutionCount> executionCounts = executionRepository.executionCounts(this.flows, this.states, this.startDate != null ? ZonedDateTime.parse(runContext.render(this.startDate)) : null, this.endDate != null ? ZonedDateTime.parse(runContext.render(this.endDate)) : null);
        logger.trace("{} flows matching filters", (Object)executionCounts.size());
        List<Result> count = executionCounts.stream().filter(Rethrow.throwPredicate(item -> runContext.render(this.expression, (Map<String, Object>)ImmutableMap.of((Object)"count", (Object)item.getCount().intValue())).equals("true"))).map(item -> Result.builder().namespace(item.getNamespace()).flowId(item.getFlowId()).count(item.getCount()).build()).collect(Collectors.toList());
        logger.debug("{} flows matching the expression", (Object)count.size());
        return Output.builder().results(count).build();
    }

    @Generated
    protected Counts(CountsBuilder<?, ?> b) {
        super((Task.TaskBuilder)b);
        this.flows = b.flows;
        this.states = b.states;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
        this.expression = b.expression;
    }

    @Generated
    public static CountsBuilder<?, ?> builder() {
        return new CountsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Counts(super=" + super.toString() + ", flows=" + this.getFlows() + ", states=" + this.getStates() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", expression=" + this.getExpression() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Counts)) {
            return false;
        }
        Counts other = (Counts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        List<State.Type> this$states = this.getStates();
        List<State.Type> other$states = other.getStates();
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Counts;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        List<State.Type> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    @NotNull
    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public List<State.Type> getStates() {
        return this.states;
    }

    @NotNull
    @Generated
    public String getStartDate() {
        return this.startDate;
    }

    @Generated
    public String getEndDate() {
        return this.endDate;
    }

    @NotNull
    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public Counts() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private final List<Result> results;

        @ConstructorProperties(value={"results"})
        @Generated
        Output(List<Result> results) {
            this.results = results;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<Result> getResults() {
            return this.results;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<Result> results;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder results(List<Result> results) {
                this.results = results;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.results);
            }

            @Generated
            public String toString() {
                return "Counts.Output.OutputBuilder(results=" + this.results + ")";
            }
        }
    }

    @Generated
    public static abstract class CountsBuilder<C extends Counts, B extends CountsBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<Flow> flows;
        @Generated
        private List<State.Type> states;
        @Generated
        private String startDate;
        @Generated
        private String endDate;
        @Generated
        private String expression;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B flows(@NotNull List<Flow> flows) {
            this.flows = flows;
            return (B)this.self();
        }

        @Generated
        public B states(List<State.Type> states) {
            this.states = states;
            return (B)this.self();
        }

        @Generated
        public B startDate(@NotNull String startDate) {
            this.startDate = startDate;
            return (B)this.self();
        }

        @Generated
        public B endDate(String endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @Generated
        public B expression(@NotNull String expression) {
            this.expression = expression;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Counts.CountsBuilder(super=" + super.toString() + ", flows=" + this.flows + ", states=" + this.states + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", expression=" + this.expression + ")";
        }
    }

    @Generated
    private static final class CountsBuilderImpl
    extends CountsBuilder<Counts, CountsBuilderImpl> {
        @Generated
        private CountsBuilderImpl() {
        }

        @Override
        @Generated
        protected CountsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Counts build() {
            return new Counts(this);
        }
    }

    public static class Result {
        private String namespace;
        private String flowId;
        private Long count;

        @ConstructorProperties(value={"namespace", "flowId", "count"})
        @Generated
        Result(String namespace, String flowId, Long count) {
            this.namespace = namespace;
            this.flowId = flowId;
            this.count = count;
        }

        @Generated
        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getFlowId() {
            return this.flowId;
        }

        @Generated
        public Long getCount() {
            return this.count;
        }

        @Generated
        public static class ResultBuilder {
            @Generated
            private String namespace;
            @Generated
            private String flowId;
            @Generated
            private Long count;

            @Generated
            ResultBuilder() {
            }

            @Generated
            public ResultBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public ResultBuilder flowId(String flowId) {
                this.flowId = flowId;
                return this;
            }

            @Generated
            public ResultBuilder count(Long count) {
                this.count = count;
                return this;
            }

            @Generated
            public Result build() {
                return new Result(this.namespace, this.flowId, this.count);
            }

            @Generated
            public String toString() {
                return "Counts.Result.ResultBuilder(namespace=" + this.namespace + ", flowId=" + this.flowId + ", count=" + this.count + ")";
            }
        }
    }
}

