/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.flows.Sequential;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Allow a task to failed", description="If any child tasks failed, the flow will stop child tasks, but will continue the main flow.")
@Plugin(examples={@Example(full=true, code={"id: allow-failure", "namespace: io.kestra.tests", "", "tasks:", "  - id: sequential", "    type: io.kestra.core.tasks.flows.AllowFailure", "    tasks:", "     - id: ko", "       type: io.kestra.core.tasks.scripts.Bash", "       commands:", "        - 'exit 1'", "  - id: last", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{task.id}} > {{taskrun.startDate}}\""})})
public class AllowFailure
extends Sequential
implements FlowableTask<VoidOutput> {
    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> resolvedErrors;
        List<ResolvedTask> resolvedTasks = this.childTasks(runContext, parentTaskRun);
        Optional<State.Type> type = FlowableUtils.resolveState(execution, resolvedTasks, resolvedErrors = FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), parentTaskRun, runContext);
        if (type.isEmpty()) {
            return type;
        }
        Optional<State.Type> normalState = FlowableUtils.resolveState(execution, resolvedTasks, null, parentTaskRun, runContext);
        if (normalState.isPresent() && normalState.get().isFailed()) {
            return Optional.of(State.Type.WARNING);
        }
        return type;
    }

    @Generated
    protected AllowFailure(AllowFailureBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
    }

    @Generated
    public static AllowFailureBuilder<?, ?> builder() {
        return new AllowFailureBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "AllowFailure(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowFailure)) {
            return false;
        }
        AllowFailure other = (AllowFailure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AllowFailure;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public AllowFailure() {
    }

    @Generated
    private static final class AllowFailureBuilderImpl
    extends AllowFailureBuilder<AllowFailure, AllowFailureBuilderImpl> {
        @Generated
        private AllowFailureBuilderImpl() {
        }

        @Override
        @Generated
        protected AllowFailureBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AllowFailure build() {
            return new AllowFailure(this);
        }
    }

    @Generated
    public static abstract class AllowFailureBuilder<C extends AllowFailure, B extends AllowFailureBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AllowFailure.AllowFailureBuilder(super=" + super.toString() + ")";
        }
    }
}

