/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.GraphService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;

@Schema(title="Process tasks ones after others sequentially", description="Mostly use in order to group tasks.")
@Plugin(examples={@Example(full=true, code={"id: sequential", "namespace: io.kestra.tests", "", "tasks:", "  - id: sequential", "    type: io.kestra.core.tasks.flows.Sequential", "    tasks:", "      - id: 1st", "        type: io.kestra.core.tasks.debugs.Return", "        format: \"{{task.id}} > {{taskrun.startDate}}\"", "      - id: 2nd", "        type: io.kestra.core.tasks.debugs.Return", "        format: \"{{task.id}} > {{taskrun.id}}\"", "  - id: last", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{task.id}} > {{taskrun.startDate}}\""})})
public class Sequential
extends Task
implements FlowableTask<VoidOutput> {
    @Valid
    protected List<Task> errors;
    @Valid
    @NotEmpty
    private List<Task> tasks;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.SEQUENTIAL);
        GraphService.sequential(subGraph, this.tasks, this.errors, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.tasks != null ? this.tasks.stream() : Stream.empty(), this.errors != null ? this.errors.stream() : Stream.empty()).collect(Collectors.toList());
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveTasks(this.tasks, parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), parentTaskRun);
    }

    @Generated
    protected Sequential(SequentialBuilder<?, ?> b) {
        super((Task.TaskBuilder)b);
        this.errors = b.errors;
        this.tasks = b.tasks;
    }

    @Generated
    public static SequentialBuilder<?, ?> builder() {
        return new SequentialBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Sequential(super=" + super.toString() + ", errors=" + this.getErrors() + ", tasks=" + this.getTasks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sequential)) {
            return false;
        }
        Sequential other = (Sequential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Sequential;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public Sequential() {
    }

    @Generated
    public static abstract class SequentialBuilder<C extends Sequential, B extends SequentialBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> tasks;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Sequential.SequentialBuilder(super=" + super.toString() + ", errors=" + this.errors + ", tasks=" + this.tasks + ")";
        }
    }

    @Generated
    private static final class SequentialBuilderImpl
    extends SequentialBuilder<Sequential, SequentialBuilderImpl> {
        @Generated
        private SequentialBuilderImpl() {
        }

        @Override
        @Generated
        protected SequentialBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Sequential build() {
            return new Sequential(this);
        }
    }
}

