/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.AbstractLogThread;
import io.kestra.core.tasks.scripts.BashService;
import io.kestra.core.tasks.scripts.RunResult;
import io.kestra.core.tasks.scripts.ScriptOutput;
import io.kestra.core.tasks.scripts.runners.DockerScriptRunner;
import io.kestra.core.tasks.scripts.runners.ProcessBuilderScriptRunner;
import io.kestra.core.tasks.scripts.runners.ScriptRunnerInterface;
import io.kestra.core.utils.Rethrow;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class AbstractBash
extends Task {
    @Schema(title="Runner to use")
    @PluginProperty(dynamic=false)
    @NotNull
    @NotEmpty
    protected Runner runner;
    @Schema(title="Docker options when using runner `DOCKER`")
    protected DockerOptions dockerOptions;
    @Schema(title="Interpreter to used")
    @PluginProperty(dynamic=false)
    @NotNull
    @NotEmpty
    protected String interpreter;
    @Schema(title="Interpreter args used")
    @PluginProperty(dynamic=false)
    protected String[] interpreterArgs;
    @Schema(title="Exit if any non true return value", description="This tells bash that it should exit the script if any statement returns a non-true return value. \nThe benefit of using -e is that it prevents errors snowballing into serious issues when they could have been caught earlier.")
    @PluginProperty(dynamic=false)
    @NotNull
    protected Boolean exitOnFailed;
    @Schema(title="The list of files that will be uploaded to internal storage, ", description="use `outputFiles` property instead", deprecated=true)
    @PluginProperty(dynamic=true)
    @Deprecated
    protected List<String> files;
    @Schema(title="Deprecated Output file", description="use `outputFiles`", deprecated=true)
    @PluginProperty(dynamic=false)
    @Deprecated
    protected List<String> outputsFiles;
    @Schema(title="Output file list that will be uploaded to internal storage", description="List of key that will generate temporary files.\nOn the command, just can use with special variable named `outputFiles.key`.\nIf you add a files with `[\"first\"]`, you can use the special vars `echo 1 >> {[ outputFiles.first }}` and you used on others tasks using `{{ outputs.task-id.files.first }}`")
    @PluginProperty(dynamic=false)
    protected List<String> outputFiles;
    @Schema(title="Output dirs list that will be uploaded to internal storage", description="List of key that will generate temporary directories.\nOn the command, just can use with special variable named `outputDirs.key`.\nIf you add a files with `[\"myDir\"]`, you can use the special vars `echo 1 >> {[ outputDirs.myDir }}/file1.txt` and `echo 2 >> {[ outputDirs.myDir }}/file2.txt` and both files will be uploaded to internal storage. Then you can used them on others tasks using `{{ outputs.taskId.files['myDir/file1.txt'] }}`")
    @PluginProperty(dynamic=false)
    protected List<String> outputDirs;
    @Schema(title="Input files are extra files supplied by user that make it simpler organize code.", description="Describe a files map (that can be a map or a json string) that will be written and usable in execution context. You can reach files using a workingDir variable like 'source {{workingDir}}/myfile.sh' ")
    @PluginProperty(additionalProperties=String.class, dynamic=true)
    protected Object inputFiles;
    @Schema(title="Additional environnements variable to add for current process.")
    @PluginProperty(additionalProperties=String.class, dynamic=true)
    protected Map<String, String> env;
    @Schema(title="Use `WARNING` state if any stdErr is sent")
    @PluginProperty(dynamic=false)
    @NotNull
    protected Boolean warningOnStdErr;
    protected transient Path workingDirectory;
    protected transient Map<String, Object> additionalVars;

    protected Map<String, String> finalInputFiles(RunContext runContext) throws IOException, IllegalVariableEvaluationException {
        return this.inputFiles != null ? new HashMap<String, String>(BashService.transformInputFiles(runContext, this.inputFiles)) : new HashMap();
    }

    protected Map<String, String> finalEnv() throws IOException {
        return this.env != null ? new HashMap<String, String>(this.env) : new HashMap();
    }

    protected List<String> finalCommandsWithInterpreter(String commandAsString) throws IOException {
        return BashService.finalCommandsWithInterpreter(this.interpreter, this.interpreterArgs, commandAsString, this.workingDirectory);
    }

    protected ScriptOutput run(RunContext runContext, Supplier<String> supplier) throws Exception {
        Logger logger = runContext.logger();
        if (this.workingDirectory == null) {
            this.workingDirectory = runContext.tempDir();
        }
        this.additionalVars.put("workingDir", this.workingDirectory.toAbsolutePath().toString());
        ArrayList<String> allOutputs = new ArrayList<String>();
        if (this.outputFiles != null && this.outputFiles.size() > 0) {
            allOutputs.addAll(this.outputFiles);
        }
        if (this.outputsFiles != null && this.outputsFiles.size() > 0) {
            allOutputs.addAll(this.outputsFiles);
        }
        if (this.files != null && this.files.size() > 0) {
            allOutputs.addAll(this.files);
        }
        Map<String, String> outputFiles = BashService.createOutputFiles(this.workingDirectory, allOutputs, this.additionalVars);
        BashService.createInputFiles(runContext, this.workingDirectory, this.finalInputFiles(runContext), this.additionalVars);
        ArrayList<String> allOutputDirs = new ArrayList<String>();
        if (this.outputDirs != null && this.outputDirs.size() > 0) {
            allOutputDirs.addAll(this.outputDirs);
        }
        Map<String, String> outputDirs = BashService.createOutputFiles(this.workingDirectory, allOutputDirs, this.additionalVars, true);
        String commandAsString = supplier.get();
        RunResult runResult = this.run(runContext, logger, this.workingDirectory, this.finalCommandsWithInterpreter(commandAsString), this.finalEnv(), this.defaultLogSupplier(logger, runContext));
        HashMap<String, URI> uploaded = new HashMap<String, URI>();
        outputFiles.forEach(Rethrow.throwBiConsumer((k, v) -> uploaded.put((String)k, runContext.putTempFile(new File(runContext.render((String)v, this.additionalVars))))));
        outputDirs.forEach(Rethrow.throwBiConsumer((k, v) -> {
            try (Stream<Path> walk = Files.walk(new File(runContext.render((String)v, this.additionalVars)).toPath(), new FileVisitOption[0]);){
                walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(Rethrow.throwConsumer(path -> {
                    String filename = Path.of(k, Path.of(runContext.render((String)v, this.additionalVars), new String[0]).relativize((Path)path).toString()).toString();
                    uploaded.put(filename, runContext.putTempFile(path.toFile(), filename));
                }));
            }
        }));
        HashMap<String, Object> outputsVars = new HashMap<String, Object>();
        outputsVars.putAll(runResult.getStdOut().getOutputs());
        outputsVars.putAll(runResult.getStdErr().getOutputs());
        return ScriptOutput.builder().exitCode(runResult.getExitCode()).stdOutLineCount(runResult.getStdOut().getLogsCount()).stdErrLineCount(runResult.getStdErr().getLogsCount()).warningOnStdErr(this.warningOnStdErr).vars(outputsVars).files(uploaded).outputFiles(uploaded).build();
    }

    protected LogSupplier defaultLogSupplier(Logger logger, RunContext runContext) {
        return (inputStream, isStdErr) -> {
            LogThread thread = new LogThread(logger, inputStream, isStdErr, runContext);
            thread.setName("bash-log-" + (isStdErr ? "-err" : "-out"));
            thread.start();
            return thread;
        };
    }

    protected RunResult run(RunContext runContext, Logger logger, Path workingDirectory, List<String> commandsWithInterpreter, Map<String, String> env, LogSupplier logSupplier) throws Exception {
        ScriptRunnerInterface executor = this.runner == Runner.DOCKER ? new DockerScriptRunner(runContext.getApplicationContext()) : new ProcessBuilderScriptRunner();
        return executor.run(this, runContext, logger, workingDirectory, commandsWithInterpreter, env, logSupplier, this.additionalVars);
    }

    @Generated
    private static Runner $default$runner() {
        return Runner.PROCESS;
    }

    @Generated
    private static String $default$interpreter() {
        return "/bin/sh";
    }

    @Generated
    private static String[] $default$interpreterArgs() {
        return new String[]{"-c"};
    }

    @Generated
    private static Boolean $default$exitOnFailed() {
        return true;
    }

    @Generated
    private static Boolean $default$warningOnStdErr() {
        return true;
    }

    @Generated
    private static Map<String, Object> $default$additionalVars() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected AbstractBash(AbstractBashBuilder<?, ?> b) {
        super(b);
        this.runner = b.runner$set ? b.runner$value : AbstractBash.$default$runner();
        this.dockerOptions = b.dockerOptions;
        this.interpreter = b.interpreter$set ? b.interpreter$value : AbstractBash.$default$interpreter();
        this.interpreterArgs = b.interpreterArgs$set ? b.interpreterArgs$value : AbstractBash.$default$interpreterArgs();
        this.exitOnFailed = b.exitOnFailed$set ? b.exitOnFailed$value : AbstractBash.$default$exitOnFailed();
        this.files = b.files;
        this.outputsFiles = b.outputsFiles;
        this.outputFiles = b.outputFiles;
        this.outputDirs = b.outputDirs;
        this.inputFiles = b.inputFiles;
        this.env = b.env;
        this.warningOnStdErr = b.warningOnStdErr$set ? b.warningOnStdErr$value : AbstractBash.$default$warningOnStdErr();
        this.workingDirectory = b.workingDirectory;
        this.additionalVars = b.additionalVars$set ? b.additionalVars$value : AbstractBash.$default$additionalVars();
    }

    @Generated
    public String toString() {
        return "AbstractBash(super=" + super.toString() + ", runner=" + this.getRunner() + ", dockerOptions=" + this.getDockerOptions() + ", interpreter=" + this.getInterpreter() + ", interpreterArgs=" + Arrays.deepToString(this.getInterpreterArgs()) + ", exitOnFailed=" + this.getExitOnFailed() + ", files=" + this.getFiles() + ", outputsFiles=" + this.getOutputsFiles() + ", outputFiles=" + this.getOutputFiles() + ", outputDirs=" + this.getOutputDirs() + ", inputFiles=" + this.getInputFiles() + ", env=" + this.getEnv() + ", warningOnStdErr=" + this.getWarningOnStdErr() + ", workingDirectory=" + this.workingDirectory + ", additionalVars=" + this.additionalVars + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBash)) {
            return false;
        }
        AbstractBash other = (AbstractBash)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$exitOnFailed = this.getExitOnFailed();
        Boolean other$exitOnFailed = other.getExitOnFailed();
        if (this$exitOnFailed == null ? other$exitOnFailed != null : !((Object)this$exitOnFailed).equals(other$exitOnFailed)) {
            return false;
        }
        Boolean this$warningOnStdErr = this.getWarningOnStdErr();
        Boolean other$warningOnStdErr = other.getWarningOnStdErr();
        if (this$warningOnStdErr == null ? other$warningOnStdErr != null : !((Object)this$warningOnStdErr).equals(other$warningOnStdErr)) {
            return false;
        }
        Runner this$runner = this.getRunner();
        Runner other$runner = other.getRunner();
        if (this$runner == null ? other$runner != null : !((Object)((Object)this$runner)).equals((Object)other$runner)) {
            return false;
        }
        DockerOptions this$dockerOptions = this.getDockerOptions();
        DockerOptions other$dockerOptions = other.getDockerOptions();
        if (this$dockerOptions == null ? other$dockerOptions != null : !this$dockerOptions.equals(other$dockerOptions)) {
            return false;
        }
        String this$interpreter = this.getInterpreter();
        String other$interpreter = other.getInterpreter();
        if (this$interpreter == null ? other$interpreter != null : !this$interpreter.equals(other$interpreter)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInterpreterArgs(), other.getInterpreterArgs())) {
            return false;
        }
        List<String> this$files = this.getFiles();
        List<String> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        List<String> this$outputsFiles = this.getOutputsFiles();
        List<String> other$outputsFiles = other.getOutputsFiles();
        if (this$outputsFiles == null ? other$outputsFiles != null : !((Object)this$outputsFiles).equals(other$outputsFiles)) {
            return false;
        }
        List<String> this$outputFiles = this.getOutputFiles();
        List<String> other$outputFiles = other.getOutputFiles();
        if (this$outputFiles == null ? other$outputFiles != null : !((Object)this$outputFiles).equals(other$outputFiles)) {
            return false;
        }
        List<String> this$outputDirs = this.getOutputDirs();
        List<String> other$outputDirs = other.getOutputDirs();
        if (this$outputDirs == null ? other$outputDirs != null : !((Object)this$outputDirs).equals(other$outputDirs)) {
            return false;
        }
        Object this$inputFiles = this.getInputFiles();
        Object other$inputFiles = other.getInputFiles();
        if (this$inputFiles == null ? other$inputFiles != null : !this$inputFiles.equals(other$inputFiles)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !((Object)this$env).equals(other$env));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractBash;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $exitOnFailed = this.getExitOnFailed();
        result = result * 59 + ($exitOnFailed == null ? 43 : ((Object)$exitOnFailed).hashCode());
        Boolean $warningOnStdErr = this.getWarningOnStdErr();
        result = result * 59 + ($warningOnStdErr == null ? 43 : ((Object)$warningOnStdErr).hashCode());
        Runner $runner = this.getRunner();
        result = result * 59 + ($runner == null ? 43 : ((Object)((Object)$runner)).hashCode());
        DockerOptions $dockerOptions = this.getDockerOptions();
        result = result * 59 + ($dockerOptions == null ? 43 : $dockerOptions.hashCode());
        String $interpreter = this.getInterpreter();
        result = result * 59 + ($interpreter == null ? 43 : $interpreter.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInterpreterArgs());
        List<String> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        List<String> $outputsFiles = this.getOutputsFiles();
        result = result * 59 + ($outputsFiles == null ? 43 : ((Object)$outputsFiles).hashCode());
        List<String> $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : ((Object)$outputFiles).hashCode());
        List<String> $outputDirs = this.getOutputDirs();
        result = result * 59 + ($outputDirs == null ? 43 : ((Object)$outputDirs).hashCode());
        Object $inputFiles = this.getInputFiles();
        result = result * 59 + ($inputFiles == null ? 43 : $inputFiles.hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public Runner getRunner() {
        return this.runner;
    }

    @Generated
    public DockerOptions getDockerOptions() {
        return this.dockerOptions;
    }

    @NotNull
    @Generated
    public String getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public String[] getInterpreterArgs() {
        return this.interpreterArgs;
    }

    @NotNull
    @Generated
    public Boolean getExitOnFailed() {
        return this.exitOnFailed;
    }

    @Deprecated
    @Generated
    public List<String> getFiles() {
        return this.files;
    }

    @Deprecated
    @Generated
    public List<String> getOutputsFiles() {
        return this.outputsFiles;
    }

    @Generated
    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public List<String> getOutputDirs() {
        return this.outputDirs;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @NotNull
    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public AbstractBash() {
        this.runner = AbstractBash.$default$runner();
        this.interpreter = AbstractBash.$default$interpreter();
        this.interpreterArgs = AbstractBash.$default$interpreterArgs();
        this.exitOnFailed = AbstractBash.$default$exitOnFailed();
        this.warningOnStdErr = AbstractBash.$default$warningOnStdErr();
        this.additionalVars = AbstractBash.$default$additionalVars();
    }

    @FunctionalInterface
    public static interface LogSupplier {
        public AbstractLogThread call(InputStream var1, boolean var2) throws Exception;
    }

    public static enum Runner {
        PROCESS,
        DOCKER;

    }

    @Generated
    public static abstract class AbstractBashBuilder<C extends AbstractBash, B extends AbstractBashBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean runner$set;
        @Generated
        private Runner runner$value;
        @Generated
        private DockerOptions dockerOptions;
        @Generated
        private boolean interpreter$set;
        @Generated
        private String interpreter$value;
        @Generated
        private boolean interpreterArgs$set;
        @Generated
        private String[] interpreterArgs$value;
        @Generated
        private boolean exitOnFailed$set;
        @Generated
        private Boolean exitOnFailed$value;
        @Generated
        private List<String> files;
        @Generated
        private List<String> outputsFiles;
        @Generated
        private List<String> outputFiles;
        @Generated
        private List<String> outputDirs;
        @Generated
        private Object inputFiles;
        @Generated
        private Map<String, String> env;
        @Generated
        private boolean warningOnStdErr$set;
        @Generated
        private Boolean warningOnStdErr$value;
        @Generated
        private Path workingDirectory;
        @Generated
        private boolean additionalVars$set;
        @Generated
        private Map<String, Object> additionalVars$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B runner(@NotNull Runner runner) {
            this.runner$value = runner;
            this.runner$set = true;
            return (B)this.self();
        }

        @Generated
        public B dockerOptions(DockerOptions dockerOptions) {
            this.dockerOptions = dockerOptions;
            return (B)this.self();
        }

        @Generated
        public B interpreter(@NotNull String interpreter) {
            this.interpreter$value = interpreter;
            this.interpreter$set = true;
            return (B)this.self();
        }

        @Generated
        public B interpreterArgs(String[] interpreterArgs) {
            this.interpreterArgs$value = interpreterArgs;
            this.interpreterArgs$set = true;
            return (B)this.self();
        }

        @Generated
        public B exitOnFailed(@NotNull Boolean exitOnFailed) {
            this.exitOnFailed$value = exitOnFailed;
            this.exitOnFailed$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B files(List<String> files) {
            this.files = files;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B outputsFiles(List<String> outputsFiles) {
            this.outputsFiles = outputsFiles;
            return (B)this.self();
        }

        @Generated
        public B outputFiles(List<String> outputFiles) {
            this.outputFiles = outputFiles;
            return (B)this.self();
        }

        @Generated
        public B outputDirs(List<String> outputDirs) {
            this.outputDirs = outputDirs;
            return (B)this.self();
        }

        @Generated
        public B inputFiles(Object inputFiles) {
            this.inputFiles = inputFiles;
            return (B)this.self();
        }

        @Generated
        public B env(Map<String, String> env) {
            this.env = env;
            return (B)this.self();
        }

        @Generated
        public B warningOnStdErr(@NotNull Boolean warningOnStdErr) {
            this.warningOnStdErr$value = warningOnStdErr;
            this.warningOnStdErr$set = true;
            return (B)this.self();
        }

        @Generated
        public B workingDirectory(Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return (B)this.self();
        }

        @Generated
        public B additionalVars(Map<String, Object> additionalVars) {
            this.additionalVars$value = additionalVars;
            this.additionalVars$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AbstractBash.AbstractBashBuilder(super=" + super.toString() + ", runner$value=" + this.runner$value + ", dockerOptions=" + this.dockerOptions + ", interpreter$value=" + this.interpreter$value + ", interpreterArgs$value=" + Arrays.deepToString(this.interpreterArgs$value) + ", exitOnFailed$value=" + this.exitOnFailed$value + ", files=" + this.files + ", outputsFiles=" + this.outputsFiles + ", outputFiles=" + this.outputFiles + ", outputDirs=" + this.outputDirs + ", inputFiles=" + this.inputFiles + ", env=" + this.env + ", warningOnStdErr$value=" + this.warningOnStdErr$value + ", workingDirectory=" + this.workingDirectory + ", additionalVars$value=" + this.additionalVars$value + ")";
        }
    }

    @Introspected
    public static class DockerOptions {
        @Schema(title="Docker api uri")
        @PluginProperty(dynamic=true)
        private String dockerHost;
        @Schema(title="Docker config file", description="Full file that can be used to configure private registries, ...")
        @PluginProperty(dynamic=true)
        private String dockerConfig;
        @Schema(title="Docker image to use")
        @PluginProperty(dynamic=true)
        @NotNull
        @NotEmpty
        protected String image;
        @Schema(title="Docker user to use")
        @PluginProperty(dynamic=true)
        protected String user;
        @Schema(title="Docker entrypoint to use")
        @PluginProperty(dynamic=true)
        protected List<String> entryPoint;
        @Schema(title="Docker extra host to use")
        @PluginProperty(dynamic=true)
        protected List<String> extraHosts;
        @Schema(title="Docker network mode to use")
        @PluginProperty(dynamic=true)
        protected String networkMode;
        @Schema(title="List of volumes to mount", description="Must be a valid mount expression as string, example : `/home/user:/app`\n\nVolumes mount are disabled by default for security reasons, you must enabled on server configuration with `kestra.tasks.scripts.docker.volume-enabled` to `true`")
        @PluginProperty(dynamic=true)
        protected List<String> volumes;
        @Schema(title="Is a pull of image must be done before starting the container", description="Mostly used for local image with registry")
        @PluginProperty(dynamic=false)
        protected Boolean pullImage;
        @Schema(title="A list of request for devices to be sent to device drivers")
        @PluginProperty(dynamic=false)
        protected List<DeviceRequest> deviceRequests;

        @Generated
        private static Boolean $default$pullImage() {
            return true;
        }

        @Generated
        protected DockerOptions(DockerOptionsBuilder<?, ?> b) {
            this.dockerHost = b.dockerHost;
            this.dockerConfig = b.dockerConfig;
            this.image = b.image;
            this.user = b.user;
            this.entryPoint = b.entryPoint;
            this.extraHosts = b.extraHosts;
            this.networkMode = b.networkMode;
            this.volumes = b.volumes;
            this.pullImage = b.pullImage$set ? b.pullImage$value : DockerOptions.$default$pullImage();
            this.deviceRequests = b.deviceRequests;
        }

        @Generated
        public static DockerOptionsBuilder<?, ?> builder() {
            return new DockerOptionsBuilderImpl();
        }

        @Generated
        public DockerOptions() {
            this.pullImage = DockerOptions.$default$pullImage();
        }

        @Generated
        public String getDockerHost() {
            return this.dockerHost;
        }

        @Generated
        public String getDockerConfig() {
            return this.dockerConfig;
        }

        @NotNull
        @Generated
        public String getImage() {
            return this.image;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public List<String> getEntryPoint() {
            return this.entryPoint;
        }

        @Generated
        public List<String> getExtraHosts() {
            return this.extraHosts;
        }

        @Generated
        public String getNetworkMode() {
            return this.networkMode;
        }

        @Generated
        public List<String> getVolumes() {
            return this.volumes;
        }

        @Generated
        public Boolean getPullImage() {
            return this.pullImage;
        }

        @Generated
        public List<DeviceRequest> getDeviceRequests() {
            return this.deviceRequests;
        }

        @Generated
        public static abstract class DockerOptionsBuilder<C extends DockerOptions, B extends DockerOptionsBuilder<C, B>> {
            @Generated
            private String dockerHost;
            @Generated
            private String dockerConfig;
            @Generated
            private String image;
            @Generated
            private String user;
            @Generated
            private List<String> entryPoint;
            @Generated
            private List<String> extraHosts;
            @Generated
            private String networkMode;
            @Generated
            private List<String> volumes;
            @Generated
            private boolean pullImage$set;
            @Generated
            private Boolean pullImage$value;
            @Generated
            private List<DeviceRequest> deviceRequests;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B dockerHost(String dockerHost) {
                this.dockerHost = dockerHost;
                return this.self();
            }

            @Generated
            public B dockerConfig(String dockerConfig) {
                this.dockerConfig = dockerConfig;
                return this.self();
            }

            @Generated
            public B image(@NotNull String image) {
                this.image = image;
                return this.self();
            }

            @Generated
            public B user(String user) {
                this.user = user;
                return this.self();
            }

            @Generated
            public B entryPoint(List<String> entryPoint) {
                this.entryPoint = entryPoint;
                return this.self();
            }

            @Generated
            public B extraHosts(List<String> extraHosts) {
                this.extraHosts = extraHosts;
                return this.self();
            }

            @Generated
            public B networkMode(String networkMode) {
                this.networkMode = networkMode;
                return this.self();
            }

            @Generated
            public B volumes(List<String> volumes) {
                this.volumes = volumes;
                return this.self();
            }

            @Generated
            public B pullImage(Boolean pullImage) {
                this.pullImage$value = pullImage;
                this.pullImage$set = true;
                return this.self();
            }

            @Generated
            public B deviceRequests(List<DeviceRequest> deviceRequests) {
                this.deviceRequests = deviceRequests;
                return this.self();
            }

            @Generated
            public String toString() {
                return "AbstractBash.DockerOptions.DockerOptionsBuilder(dockerHost=" + this.dockerHost + ", dockerConfig=" + this.dockerConfig + ", image=" + this.image + ", user=" + this.user + ", entryPoint=" + this.entryPoint + ", extraHosts=" + this.extraHosts + ", networkMode=" + this.networkMode + ", volumes=" + this.volumes + ", pullImage$value=" + this.pullImage$value + ", deviceRequests=" + this.deviceRequests + ")";
            }
        }

        @Generated
        private static final class DockerOptionsBuilderImpl
        extends DockerOptionsBuilder<DockerOptions, DockerOptionsBuilderImpl> {
            @Generated
            private DockerOptionsBuilderImpl() {
            }

            @Override
            @Generated
            protected DockerOptionsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DockerOptions build() {
                return new DockerOptions(this);
            }
        }

        @Introspected
        public static class DeviceRequest {
            private String driver;
            private Integer count;
            private List<String> deviceIds;
            private List<List<String>> capabilities;
            private Map<String, String> options;

            @Generated
            protected DeviceRequest(DeviceRequestBuilder<?, ?> b) {
                this.driver = b.driver;
                this.count = b.count;
                this.deviceIds = b.deviceIds;
                this.capabilities = b.capabilities;
                this.options = b.options;
            }

            @Generated
            public static DeviceRequestBuilder<?, ?> builder() {
                return new DeviceRequestBuilderImpl();
            }

            @Generated
            public DeviceRequest() {
            }

            @Generated
            public String getDriver() {
                return this.driver;
            }

            @Generated
            public Integer getCount() {
                return this.count;
            }

            @Generated
            public List<String> getDeviceIds() {
                return this.deviceIds;
            }

            @Generated
            public List<List<String>> getCapabilities() {
                return this.capabilities;
            }

            @Generated
            public Map<String, String> getOptions() {
                return this.options;
            }

            @Generated
            public static abstract class DeviceRequestBuilder<C extends DeviceRequest, B extends DeviceRequestBuilder<C, B>> {
                @Generated
                private String driver;
                @Generated
                private Integer count;
                @Generated
                private List<String> deviceIds;
                @Generated
                private List<List<String>> capabilities;
                @Generated
                private Map<String, String> options;

                @Generated
                protected abstract B self();

                @Generated
                public abstract C build();

                @Generated
                public B driver(String driver) {
                    this.driver = driver;
                    return this.self();
                }

                @Generated
                public B count(Integer count) {
                    this.count = count;
                    return this.self();
                }

                @Generated
                public B deviceIds(List<String> deviceIds) {
                    this.deviceIds = deviceIds;
                    return this.self();
                }

                @Generated
                public B capabilities(List<List<String>> capabilities) {
                    this.capabilities = capabilities;
                    return this.self();
                }

                @Generated
                public B options(Map<String, String> options) {
                    this.options = options;
                    return this.self();
                }

                @Generated
                public String toString() {
                    return "AbstractBash.DockerOptions.DeviceRequest.DeviceRequestBuilder(driver=" + this.driver + ", count=" + this.count + ", deviceIds=" + this.deviceIds + ", capabilities=" + this.capabilities + ", options=" + this.options + ")";
                }
            }

            @Generated
            private static final class DeviceRequestBuilderImpl
            extends DeviceRequestBuilder<DeviceRequest, DeviceRequestBuilderImpl> {
                @Generated
                private DeviceRequestBuilderImpl() {
                }

                @Override
                @Generated
                protected DeviceRequestBuilderImpl self() {
                    return this;
                }

                @Override
                @Generated
                public DeviceRequest build() {
                    return new DeviceRequest(this);
                }
            }
        }
    }

    public static class LogThread
    extends AbstractLogThread {
        private final Logger logger;
        private final boolean isStdErr;
        private final RunContext runContext;

        public LogThread(Logger logger, InputStream inputStream, boolean isStdErr, RunContext runContext) {
            super(inputStream);
            this.logger = logger;
            this.isStdErr = isStdErr;
            this.runContext = runContext;
        }

        @Override
        protected void call(String line) {
            this.outputs.putAll(BashService.parseOut(line, this.logger, this.runContext));
            if (this.isStdErr) {
                this.logger.warn(line);
            } else {
                this.logger.info(line);
            }
        }
    }

    public static class BashException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final int exitCode;
        private final int stdOutSize;
        private final int stdErrSize;

        public BashException(int exitCode, int stdOutSize, int stdErrSize) {
            super("Command failed with code " + exitCode);
            this.exitCode = exitCode;
            this.stdOutSize = stdOutSize;
            this.stdErrSize = stdErrSize;
        }

        @Generated
        public static BashExceptionBuilder builder() {
            return new BashExceptionBuilder();
        }

        @Generated
        public int getExitCode() {
            return this.exitCode;
        }

        @Generated
        public int getStdOutSize() {
            return this.stdOutSize;
        }

        @Generated
        public int getStdErrSize() {
            return this.stdErrSize;
        }

        @Generated
        public static class BashExceptionBuilder {
            @Generated
            private int exitCode;
            @Generated
            private int stdOutSize;
            @Generated
            private int stdErrSize;

            @Generated
            BashExceptionBuilder() {
            }

            @Generated
            public BashExceptionBuilder exitCode(int exitCode) {
                this.exitCode = exitCode;
                return this;
            }

            @Generated
            public BashExceptionBuilder stdOutSize(int stdOutSize) {
                this.stdOutSize = stdOutSize;
                return this;
            }

            @Generated
            public BashExceptionBuilder stdErrSize(int stdErrSize) {
                this.stdErrSize = stdErrSize;
                return this;
            }

            @Generated
            public BashException build() {
                return new BashException(this.exitCode, this.stdOutSize, this.stdErrSize);
            }

            @Generated
            public String toString() {
                return "AbstractBash.BashException.BashExceptionBuilder(exitCode=" + this.exitCode + ", stdOutSize=" + this.stdOutSize + ", stdErrSize=" + this.stdErrSize + ")";
            }
        }
    }

    public static class BashCommand<T> {
        private Map<String, Object> outputs;
        private List<AbstractMetricEntry<T>> metrics;

        @Generated
        public BashCommand() {
        }

        @Generated
        public Map<String, Object> getOutputs() {
            return this.outputs;
        }

        @Generated
        public List<AbstractMetricEntry<T>> getMetrics() {
            return this.metrics;
        }

        @Generated
        public void setOutputs(Map<String, Object> outputs) {
            this.outputs = outputs;
        }

        @Generated
        public void setMetrics(List<AbstractMetricEntry<T>> metrics) {
            this.metrics = metrics;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BashCommand)) {
                return false;
            }
            BashCommand other = (BashCommand)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$outputs = this.getOutputs();
            Map<String, Object> other$outputs = other.getOutputs();
            if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
                return false;
            }
            List<AbstractMetricEntry<T>> this$metrics = this.getMetrics();
            List<AbstractMetricEntry<T>> other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BashCommand;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $outputs = this.getOutputs();
            result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
            List<AbstractMetricEntry<T>> $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractBash.BashCommand(outputs=" + this.getOutputs() + ", metrics=" + this.getMetrics() + ")";
        }
    }
}

