/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts.runners;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.AbstractBash;
import io.kestra.core.tasks.scripts.RunResult;
import io.kestra.core.tasks.scripts.runners.ScriptRunnerInterface;
import io.kestra.core.utils.RetryUtils;
import io.kestra.core.utils.Slugify;
import io.micronaut.context.ApplicationContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.slf4j.Logger;

public class DockerScriptRunner
implements ScriptRunnerInterface {
    private final RetryUtils retryUtils;
    private final Boolean volumesEnabled;

    public DockerScriptRunner(ApplicationContext applicationContext) {
        this.retryUtils = (RetryUtils)applicationContext.getBean(RetryUtils.class);
        this.volumesEnabled = applicationContext.getProperty("kestra.tasks.scripts.docker.volume-enabled", Boolean.class).orElse(false);
    }

    private DockerClient getDockerClient(AbstractBash abstractBash, RunContext runContext, Path workingDirectory) throws IllegalVariableEvaluationException, IOException {
        DefaultDockerClientConfig.Builder dockerClientConfigBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        String dockerHost = null;
        if (abstractBash.getDockerOptions() != null) {
            if (abstractBash.getDockerOptions().getDockerHost() != null) {
                dockerHost = runContext.render(abstractBash.getDockerOptions().getDockerHost());
            }
            if (abstractBash.getDockerOptions().getDockerConfig() != null) {
                Path docker = Files.createTempDirectory(workingDirectory, "docker", new FileAttribute[0]);
                Path file = Files.createFile(docker.resolve("config.json"), new FileAttribute[0]);
                Files.write(file, runContext.render(abstractBash.getDockerOptions().getDockerConfig()).getBytes(), new OpenOption[0]);
                dockerClientConfigBuilder.withDockerConfig(docker.toFile().getAbsolutePath());
            }
        }
        if (dockerHost != null) {
            dockerClientConfigBuilder.withDockerHost(dockerHost);
        } else if (Files.exists(Path.of("/var/run/docker.sock", new String[0]), new LinkOption[0])) {
            dockerClientConfigBuilder.withDockerHost("unix:///var/run/docker.sock");
        } else if (Files.exists(Path.of("/dind/docker.sock", new String[0]), new LinkOption[0])) {
            dockerClientConfigBuilder.withDockerHost("unix:///dind/docker.sock");
        }
        DefaultDockerClientConfig dockerClientConfig = dockerClientConfigBuilder.build();
        ApacheDockerHttpClient dockerHttpClient = new ApacheDockerHttpClient.Builder().dockerHost(dockerClientConfig.getDockerHost()).build();
        return DockerClientBuilder.getInstance((DockerClientConfig)dockerClientConfig).withDockerHttpClient((DockerHttpClient)dockerHttpClient).build();
    }

    private static void metadata(RunContext runContext, CreateContainerCmd container) {
        Map flow = (Map)runContext.getVariables().get("flow");
        Map task = (Map)runContext.getVariables().get("task");
        Map execution = (Map)runContext.getVariables().get("execution");
        Map taskrun = (Map)runContext.getVariables().get("taskrun");
        String name = Slugify.of(String.join((CharSequence)"-", (CharSequence)taskrun.get("id"), (CharSequence)flow.get("id"), (CharSequence)task.get("id")));
        if (name.length() > 63) {
            name = name.substring(0, 63);
        }
        name = StringUtils.stripEnd((String)name, (String)"-");
        container.withName(name);
        container.withLabels((Map)ImmutableMap.of((Object)"flow.kestra.io/id", (Object)((String)flow.get("id")), (Object)"flow.kestra.io/namespace", (Object)((String)flow.get("namespace")), (Object)"task.kestra.io/id", (Object)((String)task.get("id")), (Object)"execution.kestra.io/id", (Object)((String)execution.get("id")), (Object)"taskrun.kestra.io/id", (Object)((String)taskrun.get("id"))));
    }

    /*
     * Exception decompiling
     */
    @Override
    public RunResult run(AbstractBash abstractBash, RunContext runContext, Logger logger, Path workingDirectory, List<String> commandsWithInterpreter, Map<String, String> env, AbstractBash.LogSupplier logSupplier, Map<String, Object> additionalVars) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Boolean lambda$run$4(PullImageCmd pull, NameParser.ReposTag imageParse, Logger logger) throws Throwable {
        ((PullImageResultCallback)pull.withTag(!imageParse.tag.equals("") ? imageParse.tag : "latest").exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
        logger.debug("Image pulled [{}:{}]", (Object)pull.getRepository(), (Object)pull.getTag());
        return true;
    }

    private static /* synthetic */ boolean lambda$run$3(Boolean bool, Throwable throwable) {
        return throwable instanceof InternalServerErrorException || throwable.getCause() instanceof ConnectionClosedException;
    }

    private static /* synthetic */ DeviceRequest lambda$run$2(RunContext runContext, AbstractBash.DockerOptions.DeviceRequest deviceRequest) throws IllegalVariableEvaluationException {
        return new DeviceRequest().withDriver(runContext.render(deviceRequest.getDriver())).withCount(deviceRequest.getCount()).withDeviceIds(deviceRequest.getDeviceIds()).withCapabilities(deviceRequest.getCapabilities()).withOptions(deviceRequest.getOptions());
    }

    private static /* synthetic */ String[] lambda$run$1(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$run$0(RunContext runContext, Map additionalVars, Map.Entry r) throws IllegalVariableEvaluationException {
        return runContext.render((String)r.getKey(), (Map<String, Object>)additionalVars) + "=" + runContext.render((String)r.getValue(), (Map<String, Object>)additionalVars);
    }
}

