/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.states;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.states.AbstractState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import lombok.Generated;

@Schema(title="Delete a state from internal storage.")
@Plugin(examples={@Example(title="Delete a state isolated by flow with `default` state name ", code={"id: getState", "type: io.kestra.core.tasks.states.Delete"}, full=true)})
public class Delete
extends AbstractState
implements RunnableTask<Output> {
    @Schema(title="raise an error if the state is not found")
    @PluginProperty(dynamic=true)
    private final Boolean errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        boolean delete = this.delete(runContext);
        if (this.errorOnMissing.booleanValue() && !delete) {
            throw new FileNotFoundException("Unable to find file '" + runContext.render(this.name) + "'");
        }
        return Output.builder().deleted(delete).build();
    }

    @Generated
    private static Boolean $default$errorOnMissing() {
        return false;
    }

    @Generated
    protected Delete(DeleteBuilder<?, ?> b) {
        super((AbstractState.AbstractStateBuilder<?, ?>)b);
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Delete.$default$errorOnMissing();
    }

    @Generated
    public static DeleteBuilder<?, ?> builder() {
        return new DeleteBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Delete(super=" + super.toString() + ", errorOnMissing=" + this.getErrorOnMissing() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$errorOnMissing = this.getErrorOnMissing();
        Boolean other$errorOnMissing = other.getErrorOnMissing();
        return !(this$errorOnMissing == null ? other$errorOnMissing != null : !((Object)this$errorOnMissing).equals(other$errorOnMissing));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delete;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $errorOnMissing = this.getErrorOnMissing();
        result = result * 59 + ($errorOnMissing == null ? 43 : ((Object)$errorOnMissing).hashCode());
        return result;
    }

    @Generated
    public Boolean getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Delete() {
        this.errorOnMissing = Delete.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="If the files was really deleted")
        private final Boolean deleted;

        @ConstructorProperties(value={"deleted"})
        @Generated
        Output(Boolean deleted) {
            this.deleted = deleted;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Boolean getDeleted() {
            return this.deleted;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Boolean deleted;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder deleted(Boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.deleted);
            }

            @Generated
            public String toString() {
                return "Delete.Output.OutputBuilder(deleted=" + this.deleted + ")";
            }
        }
    }

    @Generated
    public static abstract class DeleteBuilder<C extends Delete, B extends DeleteBuilder<C, B>>
    extends AbstractState.AbstractStateBuilder<C, B> {
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Boolean errorOnMissing$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B errorOnMissing(Boolean errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Delete.DeleteBuilder(super=" + super.toString() + ", errorOnMissing$value=" + this.errorOnMissing$value + ")";
        }
    }

    @Generated
    private static final class DeleteBuilderImpl
    extends DeleteBuilder<Delete, DeleteBuilderImpl> {
        @Generated
        private DeleteBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Delete build() {
            return new Delete(this);
        }
    }
}

