/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Slugify {
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    public static String of(String input) {
        String nowhitespace = WHITESPACE.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        String slug = NONLATIN.matcher(normalized).replaceAll("");
        slug = slug.replaceAll("_", "-");
        while (slug.contains("--")) {
            slug = slug.replace("--", "-");
        }
        slug = StringUtils.removeStart((String)slug, (String)"-");
        slug = StringUtils.removeEnd((String)slug, (String)"-");
        return slug.toLowerCase(Locale.ENGLISH);
    }
}

