/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.plugins.RegisteredPlugin;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class PluginDocumentation {
    private String title;
    private String group;
    private Map<String, Map<String, List<ClassPlugin>>> classPlugins;

    private PluginDocumentation(RegisteredPlugin plugin) {
        this.title = plugin.title();
        this.group = plugin.group();
        this.classPlugins = plugin.allClassGrouped().entrySet().stream().filter(r -> !((String)r.getKey()).equals("controllers") && !((String)r.getKey()).equals("storages")).flatMap(entry -> ((List)entry.getValue()).stream().map(cls -> {
            ClassPlugin.ClassPluginBuilder builder = ClassPlugin.builder().name(cls.getName()).simpleName(cls.getSimpleName()).type((String)entry.getKey());
            if (cls.getPackageName().startsWith(this.group) && cls.getPackageName().length() > this.group.length()) {
                builder.subgroup(cls.getPackageName().substring(this.group.length() + 1));
            } else {
                builder.subgroup("");
            }
            return builder.build();
        })).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(ClassPlugin::getSubgroup).thenComparing(ClassPlugin::getType).thenComparing(ClassPlugin::getName)).collect(Collectors.groupingBy(ClassPlugin::getSubgroup, Collectors.groupingBy(ClassPlugin::getType)));
    }

    public static PluginDocumentation of(RegisteredPlugin plugin) {
        return new PluginDocumentation(plugin);
    }

    @ConstructorProperties(value={"title", "group", "classPlugins"})
    @Generated
    public PluginDocumentation(String title, String group, Map<String, Map<String, List<ClassPlugin>>> classPlugins) {
        this.title = title;
        this.group = group;
        this.classPlugins = classPlugins;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public Map<String, Map<String, List<ClassPlugin>>> getClassPlugins() {
        return this.classPlugins;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDocumentation)) {
            return false;
        }
        PluginDocumentation other = (PluginDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        Map<String, Map<String, List<ClassPlugin>>> this$classPlugins = this.getClassPlugins();
        Map<String, Map<String, List<ClassPlugin>>> other$classPlugins = other.getClassPlugins();
        return !(this$classPlugins == null ? other$classPlugins != null : !((Object)this$classPlugins).equals(other$classPlugins));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginDocumentation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        Map<String, Map<String, List<ClassPlugin>>> $classPlugins = this.getClassPlugins();
        result = result * 59 + ($classPlugins == null ? 43 : ((Object)$classPlugins).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PluginDocumentation(title=" + this.getTitle() + ", group=" + this.getGroup() + ", classPlugins=" + this.getClassPlugins() + ")";
    }

    @Generated
    public PluginDocumentation() {
    }

    public static class ClassPlugin {
        String name;
        String simpleName;
        String subgroup;
        String type;

        @Generated
        public static ClassPluginBuilder builder() {
            return new ClassPluginBuilder();
        }

        @ConstructorProperties(value={"name", "simpleName", "subgroup", "type"})
        @Generated
        public ClassPlugin(String name, String simpleName, String subgroup, String type) {
            this.name = name;
            this.simpleName = simpleName;
            this.subgroup = subgroup;
            this.type = type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getSimpleName() {
            return this.simpleName;
        }

        @Generated
        public String getSubgroup() {
            return this.subgroup;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public static class ClassPluginBuilder {
            @Generated
            private String name;
            @Generated
            private String simpleName;
            @Generated
            private String subgroup;
            @Generated
            private String type;

            @Generated
            ClassPluginBuilder() {
            }

            @Generated
            public ClassPluginBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public ClassPluginBuilder simpleName(String simpleName) {
                this.simpleName = simpleName;
                return this;
            }

            @Generated
            public ClassPluginBuilder subgroup(String subgroup) {
                this.subgroup = subgroup;
                return this;
            }

            @Generated
            public ClassPluginBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public ClassPlugin build() {
                return new ClassPlugin(this.name, this.simpleName, this.subgroup, this.type);
            }

            @Generated
            public String toString() {
                return "PluginDocumentation.ClassPlugin.ClassPluginBuilder(name=" + this.name + ", simpleName=" + this.simpleName + ", subgroup=" + this.subgroup + ", type=" + this.type + ")";
            }
        }
    }
}

