/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.metrics;

import io.kestra.core.metrics.MetricConfig;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.schedulers.SchedulerExecutionWithTrigger;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricRegistry.class);
    public static final String METRIC_WORKER_RUNNING_COUNT = "worker.running.count";
    public static final String METRIC_WORKER_QUEUED_DURATION = "worker.queued.duration";
    public static final String METRIC_WORKER_STARTED_COUNT = "worker.started.count";
    public static final String METRIC_WORKER_RETRYED_COUNT = "worker.retryed.count";
    public static final String METRIC_WORKER_TIMEOUT_COUNT = "worker.timeout.count";
    public static final String METRIC_WORKER_ENDED_COUNT = "worker.ended.count";
    public static final String METRIC_WORKER_ENDED_DURATION = "worker.ended.duration";
    public static final String EXECUTOR_TASKRUN_NEXT_COUNT = "executor.taskrun.next.count";
    public static final String EXECUTOR_TASKRUN_ENDED_COUNT = "executor.taskrun.ended.count";
    public static final String EXECUTOR_TASKRUN_ENDED_DURATION = "executor.taskrun.ended.duration";
    public static final String EXECUTOR_WORKERTASKRESULT_COUNT = "executor.workertaskresult.count";
    public static final String EXECUTOR_EXECUTION_STARTED_COUNT = "executor.execution.started.count";
    public static final String EXECUTOR_EXECUTION_END_COUNT = "executor.execution.end.count";
    public static final String EXECUTOR_EXECUTION_DURATION = "executor.execution.duration";
    public static final String METRIC_INDEXER_REQUEST_COUNT = "indexer.request.count";
    public static final String METRIC_INDEXER_REQUEST_DURATION = "indexer.request.duration";
    public static final String METRIC_INDEXER_REQUEST_RETRY_COUNT = "indexer.request.retry.count";
    public static final String METRIC_INDEXER_SERVER_DURATION = "indexer.server.duration";
    public static final String METRIC_INDEXER_MESSAGE_FAILED_COUNT = "indexer.message.failed.count";
    public static final String METRIC_INDEXER_MESSAGE_IN_COUNT = "indexer.message.in.count";
    public static final String METRIC_INDEXER_MESSAGE_OUT_COUNT = "indexer.message.out.count";
    public static final String SCHEDULER_LOOP_COUNT = "scheduler.loop.count";
    public static final String SCHEDULER_TRIGGER_COUNT = "scheduler.trigger.count";
    public static final String SCHEDULER_TRIGGER_DELAY_DURATION = "scheduler.trigger.delay.duration";
    public static final String SCHEDULER_EVALUATE_RUNNING_COUNT = "scheduler.evaluate.running.count";
    public static final String SCHEDULER_EVALUATE_COUNT = "scheduler.evaluate.count";
    public static final String SCHEDULER_EVALUATE_DURATION = "scheduler.evaluate.duration";
    public static final String SCHEDULER_EXECUTION_RUNNING_DURATION = "scheduler.execution.running.duration";
    public static final String SCHEDULER_EXECUTION_MISSING_DURATION = "scheduler.execution.missing.duration";
    public static final String STREAMS_STATE_COUNT = "stream.state.count";
    public static final String JDBC_QUERY_DURATION = "jdbc.query.duration";
    public static final String TAG_TASK_TYPE = "task_type";
    public static final String TAG_FLOW_ID = "flow_id";
    public static final String TAG_NAMESPACE_ID = "namespace_id";
    public static final String TAG_STATE = "state";
    public static final String TAG_ATTEMPT_COUNT = "attempt_count";
    @Inject
    private MeterRegistry meterRegistry;
    @Inject
    private MetricConfig metricConfig;

    public Counter counter(String name, String ... tags) {
        return this.meterRegistry.counter(this.metricName(name), tags);
    }

    @Nullable
    public <T extends Number> T gauge(String name, T number, String ... tags) {
        return (T)this.meterRegistry.gauge(this.metricName(name), (Iterable)Tags.of((String[])tags), number);
    }

    public Timer timer(String name, String ... tags) {
        return this.meterRegistry.timer(this.metricName(name), tags);
    }

    public DistributionSummary summary(String name, String ... tags) {
        return this.meterRegistry.summary(this.metricName(name), tags);
    }

    private String metricName(String name) {
        return (String)(this.metricConfig.getPrefix() != null ? this.metricConfig.getPrefix() + "." : "") + name;
    }

    public String[] tags(WorkerTask workerTask, String ... tags) {
        return (String[])ArrayUtils.addAll((Object[])((String[])ArrayUtils.addAll((Object[])this.tags(workerTask.getTask()), (Object[])tags)), (Object[])new String[]{TAG_NAMESPACE_ID, workerTask.getTaskRun().getNamespace(), TAG_FLOW_ID, workerTask.getTaskRun().getFlowId()});
    }

    public String[] tags(WorkerTaskResult workerTaskResult, String ... tags) {
        return (String[])ArrayUtils.addAll((Object[])tags, (Object[])new String[]{TAG_NAMESPACE_ID, workerTaskResult.getTaskRun().getNamespace(), TAG_FLOW_ID, workerTaskResult.getTaskRun().getFlowId(), TAG_STATE, workerTaskResult.getTaskRun().getState().getCurrent().name()});
    }

    public String[] tags(Task task) {
        return new String[]{TAG_TASK_TYPE, task.getType()};
    }

    public String[] tags(Execution execution) {
        return new String[]{TAG_FLOW_ID, execution.getFlowId(), TAG_NAMESPACE_ID, execution.getNamespace(), TAG_STATE, execution.getState().getCurrent().name()};
    }

    public String[] tags(TriggerContext triggerContext) {
        return new String[]{TAG_FLOW_ID, triggerContext.getFlowId(), TAG_NAMESPACE_ID, triggerContext.getNamespace()};
    }

    public String[] tags(SchedulerExecutionWithTrigger schedulerExecutionWithTrigger, String ... tags) {
        return (String[])ArrayUtils.addAll((Object[])this.tags(schedulerExecutionWithTrigger.getExecution()), (Object[])tags);
    }

    public Tags tags(String ... tags) {
        return Tags.of((String[])tags);
    }

    public void bind(MeterBinder meterBinder) {
        try {
            meterBinder.bindTo(this.meterRegistry);
        }
        catch (Exception e) {
            log.warn("Error on metrics", (Throwable)e);
        }
    }
}

