/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for allows events between two specific datetimes")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.DateTimeBetweenCondition", "      after: \"2013-09-08T16:19:12\""})})
public class DateTimeBetweenCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test", description="Can be any variable or any valid ISO 8601 datetime, default will use `{{ now() }}`")
    @PluginProperty(dynamic=true)
    private final String date;
    @Schema(title="The date must after this one")
    @PluginProperty(dynamic=false)
    private ZonedDateTime after;
    @Schema(title="The date must before this one")
    @PluginProperty(dynamic=false)
    private ZonedDateTime before;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        String render = conditionContext.getRunContext().render(this.date, conditionContext.getVariables());
        ZonedDateTime currentDate = DateUtils.parseZonedDateTime(render);
        if (this.before != null && this.after != null) {
            return currentDate.isAfter(this.after) && currentDate.isBefore(this.before);
        }
        if (this.before != null) {
            return currentDate.isBefore(this.before);
        }
        if (this.after != null) {
            return currentDate.isAfter(this.after);
        }
        throw new IllegalConditionEvaluation("Invalid condition with no before nor after");
    }

    @Generated
    private static String $default$date() {
        return "{{ now() }}";
    }

    @Generated
    protected DateTimeBetweenCondition(DateTimeBetweenConditionBuilder<?, ?> b) {
        super((Condition.ConditionBuilder)b);
        this.date = b.date$set ? b.date$value : DateTimeBetweenCondition.$default$date();
        this.after = b.after;
        this.before = b.before;
    }

    @Generated
    public static DateTimeBetweenConditionBuilder<?, ?> builder() {
        return new DateTimeBetweenConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DateTimeBetweenCondition(super=" + super.toString() + ", date=" + this.getDate() + ", after=" + this.getAfter() + ", before=" + this.getBefore() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateTimeBetweenCondition)) {
            return false;
        }
        DateTimeBetweenCondition other = (DateTimeBetweenCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        ZonedDateTime this$after = this.getAfter();
        ZonedDateTime other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        ZonedDateTime this$before = this.getBefore();
        ZonedDateTime other$before = other.getBefore();
        return !(this$before == null ? other$before != null : !((Object)this$before).equals(other$before));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DateTimeBetweenCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        ZonedDateTime $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        ZonedDateTime $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public ZonedDateTime getAfter() {
        return this.after;
    }

    @Generated
    public ZonedDateTime getBefore() {
        return this.before;
    }

    @Generated
    public DateTimeBetweenCondition() {
        this.date = DateTimeBetweenCondition.$default$date();
    }

    @Generated
    public static abstract class DateTimeBetweenConditionBuilder<C extends DateTimeBetweenCondition, B extends DateTimeBetweenConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private String date$value;
        @Generated
        private ZonedDateTime after;
        @Generated
        private ZonedDateTime before;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B date(@NotNull String date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B after(ZonedDateTime after) {
            this.after = after;
            return (B)this.self();
        }

        @Generated
        public B before(ZonedDateTime before) {
            this.before = before;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DateTimeBetweenCondition.DateTimeBetweenConditionBuilder(super=" + super.toString() + ", date$value=" + this.date$value + ", after=" + this.after + ", before=" + this.before + ")";
        }
    }

    @Generated
    private static final class DateTimeBetweenConditionBuilderImpl
    extends DateTimeBetweenConditionBuilder<DateTimeBetweenCondition, DateTimeBetweenConditionBuilderImpl> {
        @Generated
        private DateTimeBetweenConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected DateTimeBetweenConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DateTimeBetweenCondition build() {
            return new DateTimeBetweenCondition(this);
        }
    }
}

