/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition to have at least once conditions validated")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.OrCondition", "      conditions:", "      -  type: io.kestra.core.models.conditions.types.DayWeekCondition", "         dayOfWeek: \"MONDAY\"", "      -  type: io.kestra.core.models.conditions.types.DayWeekCondition", "         dayOfWeek: \"SUNDAY\""})})
public class OrCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @NotEmpty
    @Schema(title="The list of conditions to exclude", description="If any conditions is true, it will allow events.")
    @PluginProperty(dynamic=false)
    private List<Condition> conditions;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        return this.conditions.stream().anyMatch(Rethrow.throwPredicate(condition -> condition.test(conditionContext)));
    }

    @Generated
    protected OrCondition(OrConditionBuilder<?, ?> b) {
        super(b);
        this.conditions = b.conditions;
    }

    @Generated
    public static OrConditionBuilder<?, ?> builder() {
        return new OrConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "OrCondition(super=" + super.toString() + ", conditions=" + this.getConditions() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrCondition)) {
            return false;
        }
        OrCondition other = (OrCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Condition> this$conditions = this.getConditions();
        List<Condition> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OrCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Condition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public OrCondition() {
    }

    @Generated
    public static abstract class OrConditionBuilder<C extends OrCondition, B extends OrConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private List<Condition> conditions;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B conditions(@NotNull List<Condition> conditions) {
            this.conditions = conditions;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "OrCondition.OrConditionBuilder(super=" + super.toString() + ", conditions=" + this.conditions + ")";
        }
    }

    @Generated
    private static final class OrConditionBuilderImpl
    extends OrConditionBuilder<OrCondition, OrConditionBuilderImpl> {
        @Generated
        private OrConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected OrConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OrCondition build() {
            return new OrCondition(this);
        }
    }
}

